; TABSIZE=8 (132 COLUMNS)
;
;		BPEG: Brainstorm's JPEG-Like Decoder
;
;			 (c)1994 Brainstorm
;
;		     Written by Raphael Lemoine
;
;       RGB/CRY Output, 2x2 Subsampling, 15/16/24 Bits/Pixel
;
;                       Version: 27-dec-1994
;
;  #[ Configuration EQUates:

		.68000
		.TEXT

TRUE		.equ	1
FALSE		.equ	0

CRY15		.equ	FALSE
CRY16		.equ	FALSE
RGB15		.equ	FALSE
RGB16		.equ	TRUE
RGB32		.equ	FALSE

STATIC_TABLE	.equ	FALSE

 .IF !(CRY15|CRY16|RGB15|RGB16|RGB32)
  .PRINT "No Output Format Specified."
  .FAIL
 .ENDIF

 .IF (CRY15)&(CRY16|RGB15|RGB16|RGB32)
  .PRINT "Multiple Output Format Specified."
  .FAIL
 .ENDIF

 .IF (CRY16)&(CRY15|RGB15|RGB16|RGB32)
  .PRINT "Multiple Output Format Specified."
  .FAIL
 .ENDIF

 .IF (RGB15)&(CRY15|CRY16|RGB16|RGB32)
  .PRINT "Multiple Output Format Specified."
  .FAIL
 .ENDIF

 .IF (RGB16)&(CRY15|CRY16|RGB15|RGB32)
  .PRINT "Multiple Output Format Specified."
  .FAIL
 .ENDIF

 .IF (RGB32)&(CRY15|CRY16|RGB15|RGB16)
  .PRINT "Multiple Output Format Specified."
  .FAIL
 .ENDIF

 .IF CRY15
  .PRINT "BPEG Output Format: CRY15."
 .ENDIF

 .IF CRY16
  .PRINT "BPEG Output Format: CRY16."
 .ENDIF

 .IF RGB15
  .PRINT "BPEG Output Format: RGB15."
 .ENDIF

 .IF RGB16
  .PRINT "BPEG Output Format: RGB16."
 .ENDIF

 .IF RGB32
  .PRINT "BPEG Output Format: RGB32."
 .ENDIF

 .IF STATIC_TABLE
  .PRINT "Using Internal DataBits Buffer."
 .ELSE
  .PRINT "Using External DataBits Buffer."
 .ENDIF

;  #] Configuration EQUates: 
;  #[ Global Symbols:

 .GLOBL BPEGInit,BPEGDecode,BPEGStatus

 .IF !(STATIC_TABLE)
 .GLOBL BPEGInitTable
 .EXTERN DataBitsBuffer
 .ENDIF

 .IF (CRY15|CRY16)
 .EXTERN CRYTable
 .ENDIF

;  #] Global Symbols: 
;  #[ EQUates:

G_FLAGS 	.equ	$f02100
G_END		.equ	$f0210c
G_PC		.equ	$f02110
G_CTRL		.equ	$f02114
G_RAM		.equ	$f03000

WORKING		.equ	-1
FINISHED	.equ	0
BADFORMAT	.equ	1
HUFFMANERROR	.equ	2

;  #] EQUates: 
;  #[ BPEG Init:

BPEGInit:
 movem.l d0-d1/a0-a1,-(sp)
 moveq #0,d0
 move.l d0,G_CTRL				; Stop the GPU
 move.l d0,G_FLAGS
 lea GPUCode(pc),a0
 lea G_RAM,a1
 move.w #((GPUEndCode-GPUCode)/4)-1,d1
.Loop:
 move.l (a0)+,(a1)+				; Copy GPU Code in GPU RAM
 dbf d1,.Loop
 movem.l (sp)+,d0-d1/a0-a1
 rts

;  #] BPEG Init: 
;  #[ BPEG Decode:
;
; IN:
; A0 = BPEG Stream Pointer
; A1 = Output Buffer Pointer
; D0 = Output Buffer Width (Bytes)
; OUT:
; D0 = Return Code
BPEGDecode:
 movem.l d1-d2/a0-a5,-(sp)
 cmp.l #'BPEG',(a0)+
 bne .BadFormat
 lea G_RAM,a5
 move.l a1,B_OUTPointer-G_RAM(a5)		; Set Output Buffer Pointer in GPU
 move.l d0,B_OUTLineSize-G_RAM(a5)		; Set Output Buffer Width in GPU
 move.l #WORKING,BPEGStatus			; Set Working Flag
 lsl.l #3,d0
 moveq #0,d1
 .IF (CRY15|CRY16|RGB15|RGB16)
 moveq #$10,d2
 .ENDIF
 .IF (RGB32)
 moveq #$20,d2
 .ENDIF
 lea LastDCY-G_RAM(a5),a1
 move.l d1,(a1)+				; Clear LastDCY in GPU
 move.l d1,(a1)+				; Clear LastDCCb in GPU
 move.l d1,(a1)					; Clear LastDCCr in GPU
 move.l d0,CopyPointers+52-G_RAM(a5)		; Set DU3 Offset in GPU
 add.l d2,d0
 move.l d0,CopyPointers+72-G_RAM(a5)		; Set DU4 Offset in GPU
 move.w (a0)+,d1
 move.l d1,B_XCounter-G_RAM(a5)			; Set MCUs Image Width in GPU
 move.l d1,B_SaveXCounter-G_RAM(a5)
 move.w (a0)+,d1
 move.l d1,B_YCounter-G_RAM(a5)			; Set MCUs Image Height in GPU
 lea $40(a0),a1
 lea ZZQTMatrix(pc),a2
 lea ZZQTLMatrix-G_RAM(a5),a3
 lea ZZQTCMatrix-G_RAM(a5),a4
 moveq #$3f,d2
.Loop:
 move.l (a2)+,d0				; Get ZigZag Value
 move.l d0,d1
 move.b (a0)+,d0				; Get Luminance Quantization Value
 move.b (a1)+,d1				; Get Chrominance Quantization Value
 swap d0
 swap d1
 move.l d0,(a3)+				; Copy Luminance Quantization Value in GPU
 move.l d1,(a4)+				; Copy Chrominance Quantization Value in GPU
 dbf d2,.Loop
 move.l a1,B_INPointer-G_RAM(a5)		; Set Huffman Stream Address in GPU
 move.l #$00070007,G_END			; Set Big-Endian Order
 move.l a5,G_PC					; Set GPU PC
 neg.w d2
 move.l d2,G_CTRL				; Run GPU
 moveq #0,d0
.End:
 movem.l (sp)+,d1-d2/a0-a5
 rts

.BadFormat:
 moveq #BADFORMAT,d0
 bra.s .End

;  #] BPEG Decode: 
;  #[ BPEG Init Table:

 .IF !(STATIC_TABLE)
BPEGInitTable:
 movem.l d0-d4/a0,-(sp)
 lea DataBitsBuffer,a0
 clr.l (a0)+
 moveq #1,d0
 moveq #$a,d4
.Loop:
 move.w d0,d1
 move.w d0,d2
 add.w d1,d1
 subq.w #1,d1
 subq.w #1,d2
 move.w d2,d3
 neg.w d1
.NegLoop:
 move.w d1,(a0)+
 addq.w #1,d1
 dbf d2,.NegLoop
 subq.w #1,d1
 neg.w d1
.PosLoop:
 move.w d1,(a0)+
 addq.w #1,d1
 dbf d3,.PosLoop
 add.w d0,d0
 dbf d4,.Loop
 movem.l (sp)+,d0-d4/a0
 rts
 .ENDIF

;  #] BPEG Init Table: 
;  #[ MC68000 Tables:				; 2804/10996 Bytes
;	 #[ DataBits Table:			; 0/8192 Bytes

 .IF STATIC_TABLE
DataBitsBuffer:
 .dc.w $0000,$0000,$ffff,$0001,$fffd,$fffe,$0002,$0003,$fff9,$fffa,$fffb,$fffc,$0004,$0005,$0006,$0007
 .dc.w $fff1,$fff2,$fff3,$fff4,$fff5,$fff6,$fff7,$fff8,$0008,$0009,$000a,$000b,$000c,$000d,$000e,$000f
 .dc.w $ffe1,$ffe2,$ffe3,$ffe4,$ffe5,$ffe6,$ffe7,$ffe8,$ffe9,$ffea,$ffeb,$ffec,$ffed,$ffee,$ffef,$fff0
 .dc.w $0010,$0011,$0012,$0013,$0014,$0015,$0016,$0017,$0018,$0019,$001a,$001b,$001c,$001d,$001e,$001f
 .dc.w $ffc1,$ffc2,$ffc3,$ffc4,$ffc5,$ffc6,$ffc7,$ffc8,$ffc9,$ffca,$ffcb,$ffcc,$ffcd,$ffce,$ffcf,$ffd0
 .dc.w $ffd1,$ffd2,$ffd3,$ffd4,$ffd5,$ffd6,$ffd7,$ffd8,$ffd9,$ffda,$ffdb,$ffdc,$ffdd,$ffde,$ffdf,$ffe0
 .dc.w $0020,$0021,$0022,$0023,$0024,$0025,$0026,$0027,$0028,$0029,$002a,$002b,$002c,$002d,$002e,$002f
 .dc.w $0030,$0031,$0032,$0033,$0034,$0035,$0036,$0037,$0038,$0039,$003a,$003b,$003c,$003d,$003e,$003f
 .dc.w $ff81,$ff82,$ff83,$ff84,$ff85,$ff86,$ff87,$ff88,$ff89,$ff8a,$ff8b,$ff8c,$ff8d,$ff8e,$ff8f,$ff90
 .dc.w $ff91,$ff92,$ff93,$ff94,$ff95,$ff96,$ff97,$ff98,$ff99,$ff9a,$ff9b,$ff9c,$ff9d,$ff9e,$ff9f,$ffa0
 .dc.w $ffa1,$ffa2,$ffa3,$ffa4,$ffa5,$ffa6,$ffa7,$ffa8,$ffa9,$ffaa,$ffab,$ffac,$ffad,$ffae,$ffaf,$ffb0
 .dc.w $ffb1,$ffb2,$ffb3,$ffb4,$ffb5,$ffb6,$ffb7,$ffb8,$ffb9,$ffba,$ffbb,$ffbc,$ffbd,$ffbe,$ffbf,$ffc0
 .dc.w $0040,$0041,$0042,$0043,$0044,$0045,$0046,$0047,$0048,$0049,$004a,$004b,$004c,$004d,$004e,$004f
 .dc.w $0050,$0051,$0052,$0053,$0054,$0055,$0056,$0057,$0058,$0059,$005a,$005b,$005c,$005d,$005e,$005f
 .dc.w $0060,$0061,$0062,$0063,$0064,$0065,$0066,$0067,$0068,$0069,$006a,$006b,$006c,$006d,$006e,$006f
 .dc.w $0070,$0071,$0072,$0073,$0074,$0075,$0076,$0077,$0078,$0079,$007a,$007b,$007c,$007d,$007e,$007f
 .dc.w $ff01,$ff02,$ff03,$ff04,$ff05,$ff06,$ff07,$ff08,$ff09,$ff0a,$ff0b,$ff0c,$ff0d,$ff0e,$ff0f,$ff10
 .dc.w $ff11,$ff12,$ff13,$ff14,$ff15,$ff16,$ff17,$ff18,$ff19,$ff1a,$ff1b,$ff1c,$ff1d,$ff1e,$ff1f,$ff20
 .dc.w $ff21,$ff22,$ff23,$ff24,$ff25,$ff26,$ff27,$ff28,$ff29,$ff2a,$ff2b,$ff2c,$ff2d,$ff2e,$ff2f,$ff30
 .dc.w $ff31,$ff32,$ff33,$ff34,$ff35,$ff36,$ff37,$ff38,$ff39,$ff3a,$ff3b,$ff3c,$ff3d,$ff3e,$ff3f,$ff40
 .dc.w $ff41,$ff42,$ff43,$ff44,$ff45,$ff46,$ff47,$ff48,$ff49,$ff4a,$ff4b,$ff4c,$ff4d,$ff4e,$ff4f,$ff50
 .dc.w $ff51,$ff52,$ff53,$ff54,$ff55,$ff56,$ff57,$ff58,$ff59,$ff5a,$ff5b,$ff5c,$ff5d,$ff5e,$ff5f,$ff60
 .dc.w $ff61,$ff62,$ff63,$ff64,$ff65,$ff66,$ff67,$ff68,$ff69,$ff6a,$ff6b,$ff6c,$ff6d,$ff6e,$ff6f,$ff70
 .dc.w $ff71,$ff72,$ff73,$ff74,$ff75,$ff76,$ff77,$ff78,$ff79,$ff7a,$ff7b,$ff7c,$ff7d,$ff7e,$ff7f,$ff80
 .dc.w $0080,$0081,$0082,$0083,$0084,$0085,$0086,$0087,$0088,$0089,$008a,$008b,$008c,$008d,$008e,$008f
 .dc.w $0090,$0091,$0092,$0093,$0094,$0095,$0096,$0097,$0098,$0099,$009a,$009b,$009c,$009d,$009e,$009f
 .dc.w $00a0,$00a1,$00a2,$00a3,$00a4,$00a5,$00a6,$00a7,$00a8,$00a9,$00aa,$00ab,$00ac,$00ad,$00ae,$00af
 .dc.w $00b0,$00b1,$00b2,$00b3,$00b4,$00b5,$00b6,$00b7,$00b8,$00b9,$00ba,$00bb,$00bc,$00bd,$00be,$00bf
 .dc.w $00c0,$00c1,$00c2,$00c3,$00c4,$00c5,$00c6,$00c7,$00c8,$00c9,$00ca,$00cb,$00cc,$00cd,$00ce,$00cf
 .dc.w $00d0,$00d1,$00d2,$00d3,$00d4,$00d5,$00d6,$00d7,$00d8,$00d9,$00da,$00db,$00dc,$00dd,$00de,$00df
 .dc.w $00e0,$00e1,$00e2,$00e3,$00e4,$00e5,$00e6,$00e7,$00e8,$00e9,$00ea,$00eb,$00ec,$00ed,$00ee,$00ef
 .dc.w $00f0,$00f1,$00f2,$00f3,$00f4,$00f5,$00f6,$00f7,$00f8,$00f9,$00fa,$00fb,$00fc,$00fd,$00fe,$00ff
 .dc.w $fe01,$fe02,$fe03,$fe04,$fe05,$fe06,$fe07,$fe08,$fe09,$fe0a,$fe0b,$fe0c,$fe0d,$fe0e,$fe0f,$fe10
 .dc.w $fe11,$fe12,$fe13,$fe14,$fe15,$fe16,$fe17,$fe18,$fe19,$fe1a,$fe1b,$fe1c,$fe1d,$fe1e,$fe1f,$fe20
 .dc.w $fe21,$fe22,$fe23,$fe24,$fe25,$fe26,$fe27,$fe28,$fe29,$fe2a,$fe2b,$fe2c,$fe2d,$fe2e,$fe2f,$fe30
 .dc.w $fe31,$fe32,$fe33,$fe34,$fe35,$fe36,$fe37,$fe38,$fe39,$fe3a,$fe3b,$fe3c,$fe3d,$fe3e,$fe3f,$fe40
 .dc.w $fe41,$fe42,$fe43,$fe44,$fe45,$fe46,$fe47,$fe48,$fe49,$fe4a,$fe4b,$fe4c,$fe4d,$fe4e,$fe4f,$fe50
 .dc.w $fe51,$fe52,$fe53,$fe54,$fe55,$fe56,$fe57,$fe58,$fe59,$fe5a,$fe5b,$fe5c,$fe5d,$fe5e,$fe5f,$fe60
 .dc.w $fe61,$fe62,$fe63,$fe64,$fe65,$fe66,$fe67,$fe68,$fe69,$fe6a,$fe6b,$fe6c,$fe6d,$fe6e,$fe6f,$fe70
 .dc.w $fe71,$fe72,$fe73,$fe74,$fe75,$fe76,$fe77,$fe78,$fe79,$fe7a,$fe7b,$fe7c,$fe7d,$fe7e,$fe7f,$fe80
 .dc.w $fe81,$fe82,$fe83,$fe84,$fe85,$fe86,$fe87,$fe88,$fe89,$fe8a,$fe8b,$fe8c,$fe8d,$fe8e,$fe8f,$fe90
 .dc.w $fe91,$fe92,$fe93,$fe94,$fe95,$fe96,$fe97,$fe98,$fe99,$fe9a,$fe9b,$fe9c,$fe9d,$fe9e,$fe9f,$fea0
 .dc.w $fea1,$fea2,$fea3,$fea4,$fea5,$fea6,$fea7,$fea8,$fea9,$feaa,$feab,$feac,$fead,$feae,$feaf,$feb0
 .dc.w $feb1,$feb2,$feb3,$feb4,$feb5,$feb6,$feb7,$feb8,$feb9,$feba,$febb,$febc,$febd,$febe,$febf,$fec0
 .dc.w $fec1,$fec2,$fec3,$fec4,$fec5,$fec6,$fec7,$fec8,$fec9,$feca,$fecb,$fecc,$fecd,$fece,$fecf,$fed0
 .dc.w $fed1,$fed2,$fed3,$fed4,$fed5,$fed6,$fed7,$fed8,$fed9,$feda,$fedb,$fedc,$fedd,$fede,$fedf,$fee0
 .dc.w $fee1,$fee2,$fee3,$fee4,$fee5,$fee6,$fee7,$fee8,$fee9,$feea,$feeb,$feec,$feed,$feee,$feef,$fef0
 .dc.w $fef1,$fef2,$fef3,$fef4,$fef5,$fef6,$fef7,$fef8,$fef9,$fefa,$fefb,$fefc,$fefd,$fefe,$feff,$ff00
 .dc.w $0100,$0101,$0102,$0103,$0104,$0105,$0106,$0107,$0108,$0109,$010a,$010b,$010c,$010d,$010e,$010f
 .dc.w $0110,$0111,$0112,$0113,$0114,$0115,$0116,$0117,$0118,$0119,$011a,$011b,$011c,$011d,$011e,$011f
 .dc.w $0120,$0121,$0122,$0123,$0124,$0125,$0126,$0127,$0128,$0129,$012a,$012b,$012c,$012d,$012e,$012f
 .dc.w $0130,$0131,$0132,$0133,$0134,$0135,$0136,$0137,$0138,$0139,$013a,$013b,$013c,$013d,$013e,$013f
 .dc.w $0140,$0141,$0142,$0143,$0144,$0145,$0146,$0147,$0148,$0149,$014a,$014b,$014c,$014d,$014e,$014f
 .dc.w $0150,$0151,$0152,$0153,$0154,$0155,$0156,$0157,$0158,$0159,$015a,$015b,$015c,$015d,$015e,$015f
 .dc.w $0160,$0161,$0162,$0163,$0164,$0165,$0166,$0167,$0168,$0169,$016a,$016b,$016c,$016d,$016e,$016f
 .dc.w $0170,$0171,$0172,$0173,$0174,$0175,$0176,$0177,$0178,$0179,$017a,$017b,$017c,$017d,$017e,$017f
 .dc.w $0180,$0181,$0182,$0183,$0184,$0185,$0186,$0187,$0188,$0189,$018a,$018b,$018c,$018d,$018e,$018f
 .dc.w $0190,$0191,$0192,$0193,$0194,$0195,$0196,$0197,$0198,$0199,$019a,$019b,$019c,$019d,$019e,$019f
 .dc.w $01a0,$01a1,$01a2,$01a3,$01a4,$01a5,$01a6,$01a7,$01a8,$01a9,$01aa,$01ab,$01ac,$01ad,$01ae,$01af
 .dc.w $01b0,$01b1,$01b2,$01b3,$01b4,$01b5,$01b6,$01b7,$01b8,$01b9,$01ba,$01bb,$01bc,$01bd,$01be,$01bf
 .dc.w $01c0,$01c1,$01c2,$01c3,$01c4,$01c5,$01c6,$01c7,$01c8,$01c9,$01ca,$01cb,$01cc,$01cd,$01ce,$01cf
 .dc.w $01d0,$01d1,$01d2,$01d3,$01d4,$01d5,$01d6,$01d7,$01d8,$01d9,$01da,$01db,$01dc,$01dd,$01de,$01df
 .dc.w $01e0,$01e1,$01e2,$01e3,$01e4,$01e5,$01e6,$01e7,$01e8,$01e9,$01ea,$01eb,$01ec,$01ed,$01ee,$01ef
 .dc.w $01f0,$01f1,$01f2,$01f3,$01f4,$01f5,$01f6,$01f7,$01f8,$01f9,$01fa,$01fb,$01fc,$01fd,$01fe,$01ff
 .dc.w $fc01,$fc02,$fc03,$fc04,$fc05,$fc06,$fc07,$fc08,$fc09,$fc0a,$fc0b,$fc0c,$fc0d,$fc0e,$fc0f,$fc10
 .dc.w $fc11,$fc12,$fc13,$fc14,$fc15,$fc16,$fc17,$fc18,$fc19,$fc1a,$fc1b,$fc1c,$fc1d,$fc1e,$fc1f,$fc20
 .dc.w $fc21,$fc22,$fc23,$fc24,$fc25,$fc26,$fc27,$fc28,$fc29,$fc2a,$fc2b,$fc2c,$fc2d,$fc2e,$fc2f,$fc30
 .dc.w $fc31,$fc32,$fc33,$fc34,$fc35,$fc36,$fc37,$fc38,$fc39,$fc3a,$fc3b,$fc3c,$fc3d,$fc3e,$fc3f,$fc40
 .dc.w $fc41,$fc42,$fc43,$fc44,$fc45,$fc46,$fc47,$fc48,$fc49,$fc4a,$fc4b,$fc4c,$fc4d,$fc4e,$fc4f,$fc50
 .dc.w $fc51,$fc52,$fc53,$fc54,$fc55,$fc56,$fc57,$fc58,$fc59,$fc5a,$fc5b,$fc5c,$fc5d,$fc5e,$fc5f,$fc60
 .dc.w $fc61,$fc62,$fc63,$fc64,$fc65,$fc66,$fc67,$fc68,$fc69,$fc6a,$fc6b,$fc6c,$fc6d,$fc6e,$fc6f,$fc70
 .dc.w $fc71,$fc72,$fc73,$fc74,$fc75,$fc76,$fc77,$fc78,$fc79,$fc7a,$fc7b,$fc7c,$fc7d,$fc7e,$fc7f,$fc80
 .dc.w $fc81,$fc82,$fc83,$fc84,$fc85,$fc86,$fc87,$fc88,$fc89,$fc8a,$fc8b,$fc8c,$fc8d,$fc8e,$fc8f,$fc90
 .dc.w $fc91,$fc92,$fc93,$fc94,$fc95,$fc96,$fc97,$fc98,$fc99,$fc9a,$fc9b,$fc9c,$fc9d,$fc9e,$fc9f,$fca0
 .dc.w $fca1,$fca2,$fca3,$fca4,$fca5,$fca6,$fca7,$fca8,$fca9,$fcaa,$fcab,$fcac,$fcad,$fcae,$fcaf,$fcb0
 .dc.w $fcb1,$fcb2,$fcb3,$fcb4,$fcb5,$fcb6,$fcb7,$fcb8,$fcb9,$fcba,$fcbb,$fcbc,$fcbd,$fcbe,$fcbf,$fcc0
 .dc.w $fcc1,$fcc2,$fcc3,$fcc4,$fcc5,$fcc6,$fcc7,$fcc8,$fcc9,$fcca,$fccb,$fccc,$fccd,$fcce,$fccf,$fcd0
 .dc.w $fcd1,$fcd2,$fcd3,$fcd4,$fcd5,$fcd6,$fcd7,$fcd8,$fcd9,$fcda,$fcdb,$fcdc,$fcdd,$fcde,$fcdf,$fce0
 .dc.w $fce1,$fce2,$fce3,$fce4,$fce5,$fce6,$fce7,$fce8,$fce9,$fcea,$fceb,$fcec,$fced,$fcee,$fcef,$fcf0
 .dc.w $fcf1,$fcf2,$fcf3,$fcf4,$fcf5,$fcf6,$fcf7,$fcf8,$fcf9,$fcfa,$fcfb,$fcfc,$fcfd,$fcfe,$fcff,$fd00
 .dc.w $fd01,$fd02,$fd03,$fd04,$fd05,$fd06,$fd07,$fd08,$fd09,$fd0a,$fd0b,$fd0c,$fd0d,$fd0e,$fd0f,$fd10
 .dc.w $fd11,$fd12,$fd13,$fd14,$fd15,$fd16,$fd17,$fd18,$fd19,$fd1a,$fd1b,$fd1c,$fd1d,$fd1e,$fd1f,$fd20
 .dc.w $fd21,$fd22,$fd23,$fd24,$fd25,$fd26,$fd27,$fd28,$fd29,$fd2a,$fd2b,$fd2c,$fd2d,$fd2e,$fd2f,$fd30
 .dc.w $fd31,$fd32,$fd33,$fd34,$fd35,$fd36,$fd37,$fd38,$fd39,$fd3a,$fd3b,$fd3c,$fd3d,$fd3e,$fd3f,$fd40
 .dc.w $fd41,$fd42,$fd43,$fd44,$fd45,$fd46,$fd47,$fd48,$fd49,$fd4a,$fd4b,$fd4c,$fd4d,$fd4e,$fd4f,$fd50
 .dc.w $fd51,$fd52,$fd53,$fd54,$fd55,$fd56,$fd57,$fd58,$fd59,$fd5a,$fd5b,$fd5c,$fd5d,$fd5e,$fd5f,$fd60
 .dc.w $fd61,$fd62,$fd63,$fd64,$fd65,$fd66,$fd67,$fd68,$fd69,$fd6a,$fd6b,$fd6c,$fd6d,$fd6e,$fd6f,$fd70
 .dc.w $fd71,$fd72,$fd73,$fd74,$fd75,$fd76,$fd77,$fd78,$fd79,$fd7a,$fd7b,$fd7c,$fd7d,$fd7e,$fd7f,$fd80
 .dc.w $fd81,$fd82,$fd83,$fd84,$fd85,$fd86,$fd87,$fd88,$fd89,$fd8a,$fd8b,$fd8c,$fd8d,$fd8e,$fd8f,$fd90
 .dc.w $fd91,$fd92,$fd93,$fd94,$fd95,$fd96,$fd97,$fd98,$fd99,$fd9a,$fd9b,$fd9c,$fd9d,$fd9e,$fd9f,$fda0
 .dc.w $fda1,$fda2,$fda3,$fda4,$fda5,$fda6,$fda7,$fda8,$fda9,$fdaa,$fdab,$fdac,$fdad,$fdae,$fdaf,$fdb0
 .dc.w $fdb1,$fdb2,$fdb3,$fdb4,$fdb5,$fdb6,$fdb7,$fdb8,$fdb9,$fdba,$fdbb,$fdbc,$fdbd,$fdbe,$fdbf,$fdc0
 .dc.w $fdc1,$fdc2,$fdc3,$fdc4,$fdc5,$fdc6,$fdc7,$fdc8,$fdc9,$fdca,$fdcb,$fdcc,$fdcd,$fdce,$fdcf,$fdd0
 .dc.w $fdd1,$fdd2,$fdd3,$fdd4,$fdd5,$fdd6,$fdd7,$fdd8,$fdd9,$fdda,$fddb,$fddc,$fddd,$fdde,$fddf,$fde0
 .dc.w $fde1,$fde2,$fde3,$fde4,$fde5,$fde6,$fde7,$fde8,$fde9,$fdea,$fdeb,$fdec,$fded,$fdee,$fdef,$fdf0
 .dc.w $fdf1,$fdf2,$fdf3,$fdf4,$fdf5,$fdf6,$fdf7,$fdf8,$fdf9,$fdfa,$fdfb,$fdfc,$fdfd,$fdfe,$fdff,$fe00
 .dc.w $0200,$0201,$0202,$0203,$0204,$0205,$0206,$0207,$0208,$0209,$020a,$020b,$020c,$020d,$020e,$020f
 .dc.w $0210,$0211,$0212,$0213,$0214,$0215,$0216,$0217,$0218,$0219,$021a,$021b,$021c,$021d,$021e,$021f
 .dc.w $0220,$0221,$0222,$0223,$0224,$0225,$0226,$0227,$0228,$0229,$022a,$022b,$022c,$022d,$022e,$022f
 .dc.w $0230,$0231,$0232,$0233,$0234,$0235,$0236,$0237,$0238,$0239,$023a,$023b,$023c,$023d,$023e,$023f
 .dc.w $0240,$0241,$0242,$0243,$0244,$0245,$0246,$0247,$0248,$0249,$024a,$024b,$024c,$024d,$024e,$024f
 .dc.w $0250,$0251,$0252,$0253,$0254,$0255,$0256,$0257,$0258,$0259,$025a,$025b,$025c,$025d,$025e,$025f
 .dc.w $0260,$0261,$0262,$0263,$0264,$0265,$0266,$0267,$0268,$0269,$026a,$026b,$026c,$026d,$026e,$026f
 .dc.w $0270,$0271,$0272,$0273,$0274,$0275,$0276,$0277,$0278,$0279,$027a,$027b,$027c,$027d,$027e,$027f
 .dc.w $0280,$0281,$0282,$0283,$0284,$0285,$0286,$0287,$0288,$0289,$028a,$028b,$028c,$028d,$028e,$028f
 .dc.w $0290,$0291,$0292,$0293,$0294,$0295,$0296,$0297,$0298,$0299,$029a,$029b,$029c,$029d,$029e,$029f
 .dc.w $02a0,$02a1,$02a2,$02a3,$02a4,$02a5,$02a6,$02a7,$02a8,$02a9,$02aa,$02ab,$02ac,$02ad,$02ae,$02af
 .dc.w $02b0,$02b1,$02b2,$02b3,$02b4,$02b5,$02b6,$02b7,$02b8,$02b9,$02ba,$02bb,$02bc,$02bd,$02be,$02bf
 .dc.w $02c0,$02c1,$02c2,$02c3,$02c4,$02c5,$02c6,$02c7,$02c8,$02c9,$02ca,$02cb,$02cc,$02cd,$02ce,$02cf
 .dc.w $02d0,$02d1,$02d2,$02d3,$02d4,$02d5,$02d6,$02d7,$02d8,$02d9,$02da,$02db,$02dc,$02dd,$02de,$02df
 .dc.w $02e0,$02e1,$02e2,$02e3,$02e4,$02e5,$02e6,$02e7,$02e8,$02e9,$02ea,$02eb,$02ec,$02ed,$02ee,$02ef
 .dc.w $02f0,$02f1,$02f2,$02f3,$02f4,$02f5,$02f6,$02f7,$02f8,$02f9,$02fa,$02fb,$02fc,$02fd,$02fe,$02ff
 .dc.w $0300,$0301,$0302,$0303,$0304,$0305,$0306,$0307,$0308,$0309,$030a,$030b,$030c,$030d,$030e,$030f
 .dc.w $0310,$0311,$0312,$0313,$0314,$0315,$0316,$0317,$0318,$0319,$031a,$031b,$031c,$031d,$031e,$031f
 .dc.w $0320,$0321,$0322,$0323,$0324,$0325,$0326,$0327,$0328,$0329,$032a,$032b,$032c,$032d,$032e,$032f
 .dc.w $0330,$0331,$0332,$0333,$0334,$0335,$0336,$0337,$0338,$0339,$033a,$033b,$033c,$033d,$033e,$033f
 .dc.w $0340,$0341,$0342,$0343,$0344,$0345,$0346,$0347,$0348,$0349,$034a,$034b,$034c,$034d,$034e,$034f
 .dc.w $0350,$0351,$0352,$0353,$0354,$0355,$0356,$0357,$0358,$0359,$035a,$035b,$035c,$035d,$035e,$035f
 .dc.w $0360,$0361,$0362,$0363,$0364,$0365,$0366,$0367,$0368,$0369,$036a,$036b,$036c,$036d,$036e,$036f
 .dc.w $0370,$0371,$0372,$0373,$0374,$0375,$0376,$0377,$0378,$0379,$037a,$037b,$037c,$037d,$037e,$037f
 .dc.w $0380,$0381,$0382,$0383,$0384,$0385,$0386,$0387,$0388,$0389,$038a,$038b,$038c,$038d,$038e,$038f
 .dc.w $0390,$0391,$0392,$0393,$0394,$0395,$0396,$0397,$0398,$0399,$039a,$039b,$039c,$039d,$039e,$039f
 .dc.w $03a0,$03a1,$03a2,$03a3,$03a4,$03a5,$03a6,$03a7,$03a8,$03a9,$03aa,$03ab,$03ac,$03ad,$03ae,$03af
 .dc.w $03b0,$03b1,$03b2,$03b3,$03b4,$03b5,$03b6,$03b7,$03b8,$03b9,$03ba,$03bb,$03bc,$03bd,$03be,$03bf
 .dc.w $03c0,$03c1,$03c2,$03c3,$03c4,$03c5,$03c6,$03c7,$03c8,$03c9,$03ca,$03cb,$03cc,$03cd,$03ce,$03cf
 .dc.w $03d0,$03d1,$03d2,$03d3,$03d4,$03d5,$03d6,$03d7,$03d8,$03d9,$03da,$03db,$03dc,$03dd,$03de,$03df
 .dc.w $03e0,$03e1,$03e2,$03e3,$03e4,$03e5,$03e6,$03e7,$03e8,$03e9,$03ea,$03eb,$03ec,$03ed,$03ee,$03ef
 .dc.w $03f0,$03f1,$03f2,$03f3,$03f4,$03f5,$03f6,$03f7,$03f8,$03f9,$03fa,$03fb,$03fc,$03fd,$03fe,$03ff
 .dc.w $f801,$f802,$f803,$f804,$f805,$f806,$f807,$f808,$f809,$f80a,$f80b,$f80c,$f80d,$f80e,$f80f,$f810
 .dc.w $f811,$f812,$f813,$f814,$f815,$f816,$f817,$f818,$f819,$f81a,$f81b,$f81c,$f81d,$f81e,$f81f,$f820
 .dc.w $f821,$f822,$f823,$f824,$f825,$f826,$f827,$f828,$f829,$f82a,$f82b,$f82c,$f82d,$f82e,$f82f,$f830
 .dc.w $f831,$f832,$f833,$f834,$f835,$f836,$f837,$f838,$f839,$f83a,$f83b,$f83c,$f83d,$f83e,$f83f,$f840
 .dc.w $f841,$f842,$f843,$f844,$f845,$f846,$f847,$f848,$f849,$f84a,$f84b,$f84c,$f84d,$f84e,$f84f,$f850
 .dc.w $f851,$f852,$f853,$f854,$f855,$f856,$f857,$f858,$f859,$f85a,$f85b,$f85c,$f85d,$f85e,$f85f,$f860
 .dc.w $f861,$f862,$f863,$f864,$f865,$f866,$f867,$f868,$f869,$f86a,$f86b,$f86c,$f86d,$f86e,$f86f,$f870
 .dc.w $f871,$f872,$f873,$f874,$f875,$f876,$f877,$f878,$f879,$f87a,$f87b,$f87c,$f87d,$f87e,$f87f,$f880
 .dc.w $f881,$f882,$f883,$f884,$f885,$f886,$f887,$f888,$f889,$f88a,$f88b,$f88c,$f88d,$f88e,$f88f,$f890
 .dc.w $f891,$f892,$f893,$f894,$f895,$f896,$f897,$f898,$f899,$f89a,$f89b,$f89c,$f89d,$f89e,$f89f,$f8a0
 .dc.w $f8a1,$f8a2,$f8a3,$f8a4,$f8a5,$f8a6,$f8a7,$f8a8,$f8a9,$f8aa,$f8ab,$f8ac,$f8ad,$f8ae,$f8af,$f8b0
 .dc.w $f8b1,$f8b2,$f8b3,$f8b4,$f8b5,$f8b6,$f8b7,$f8b8,$f8b9,$f8ba,$f8bb,$f8bc,$f8bd,$f8be,$f8bf,$f8c0
 .dc.w $f8c1,$f8c2,$f8c3,$f8c4,$f8c5,$f8c6,$f8c7,$f8c8,$f8c9,$f8ca,$f8cb,$f8cc,$f8cd,$f8ce,$f8cf,$f8d0
 .dc.w $f8d1,$f8d2,$f8d3,$f8d4,$f8d5,$f8d6,$f8d7,$f8d8,$f8d9,$f8da,$f8db,$f8dc,$f8dd,$f8de,$f8df,$f8e0
 .dc.w $f8e1,$f8e2,$f8e3,$f8e4,$f8e5,$f8e6,$f8e7,$f8e8,$f8e9,$f8ea,$f8eb,$f8ec,$f8ed,$f8ee,$f8ef,$f8f0
 .dc.w $f8f1,$f8f2,$f8f3,$f8f4,$f8f5,$f8f6,$f8f7,$f8f8,$f8f9,$f8fa,$f8fb,$f8fc,$f8fd,$f8fe,$f8ff,$f900
 .dc.w $f901,$f902,$f903,$f904,$f905,$f906,$f907,$f908,$f909,$f90a,$f90b,$f90c,$f90d,$f90e,$f90f,$f910
 .dc.w $f911,$f912,$f913,$f914,$f915,$f916,$f917,$f918,$f919,$f91a,$f91b,$f91c,$f91d,$f91e,$f91f,$f920
 .dc.w $f921,$f922,$f923,$f924,$f925,$f926,$f927,$f928,$f929,$f92a,$f92b,$f92c,$f92d,$f92e,$f92f,$f930
 .dc.w $f931,$f932,$f933,$f934,$f935,$f936,$f937,$f938,$f939,$f93a,$f93b,$f93c,$f93d,$f93e,$f93f,$f940
 .dc.w $f941,$f942,$f943,$f944,$f945,$f946,$f947,$f948,$f949,$f94a,$f94b,$f94c,$f94d,$f94e,$f94f,$f950
 .dc.w $f951,$f952,$f953,$f954,$f955,$f956,$f957,$f958,$f959,$f95a,$f95b,$f95c,$f95d,$f95e,$f95f,$f960
 .dc.w $f961,$f962,$f963,$f964,$f965,$f966,$f967,$f968,$f969,$f96a,$f96b,$f96c,$f96d,$f96e,$f96f,$f970
 .dc.w $f971,$f972,$f973,$f974,$f975,$f976,$f977,$f978,$f979,$f97a,$f97b,$f97c,$f97d,$f97e,$f97f,$f980
 .dc.w $f981,$f982,$f983,$f984,$f985,$f986,$f987,$f988,$f989,$f98a,$f98b,$f98c,$f98d,$f98e,$f98f,$f990
 .dc.w $f991,$f992,$f993,$f994,$f995,$f996,$f997,$f998,$f999,$f99a,$f99b,$f99c,$f99d,$f99e,$f99f,$f9a0
 .dc.w $f9a1,$f9a2,$f9a3,$f9a4,$f9a5,$f9a6,$f9a7,$f9a8,$f9a9,$f9aa,$f9ab,$f9ac,$f9ad,$f9ae,$f9af,$f9b0
 .dc.w $f9b1,$f9b2,$f9b3,$f9b4,$f9b5,$f9b6,$f9b7,$f9b8,$f9b9,$f9ba,$f9bb,$f9bc,$f9bd,$f9be,$f9bf,$f9c0
 .dc.w $f9c1,$f9c2,$f9c3,$f9c4,$f9c5,$f9c6,$f9c7,$f9c8,$f9c9,$f9ca,$f9cb,$f9cc,$f9cd,$f9ce,$f9cf,$f9d0
 .dc.w $f9d1,$f9d2,$f9d3,$f9d4,$f9d5,$f9d6,$f9d7,$f9d8,$f9d9,$f9da,$f9db,$f9dc,$f9dd,$f9de,$f9df,$f9e0
 .dc.w $f9e1,$f9e2,$f9e3,$f9e4,$f9e5,$f9e6,$f9e7,$f9e8,$f9e9,$f9ea,$f9eb,$f9ec,$f9ed,$f9ee,$f9ef,$f9f0
 .dc.w $f9f1,$f9f2,$f9f3,$f9f4,$f9f5,$f9f6,$f9f7,$f9f8,$f9f9,$f9fa,$f9fb,$f9fc,$f9fd,$f9fe,$f9ff,$fa00
 .dc.w $fa01,$fa02,$fa03,$fa04,$fa05,$fa06,$fa07,$fa08,$fa09,$fa0a,$fa0b,$fa0c,$fa0d,$fa0e,$fa0f,$fa10
 .dc.w $fa11,$fa12,$fa13,$fa14,$fa15,$fa16,$fa17,$fa18,$fa19,$fa1a,$fa1b,$fa1c,$fa1d,$fa1e,$fa1f,$fa20
 .dc.w $fa21,$fa22,$fa23,$fa24,$fa25,$fa26,$fa27,$fa28,$fa29,$fa2a,$fa2b,$fa2c,$fa2d,$fa2e,$fa2f,$fa30
 .dc.w $fa31,$fa32,$fa33,$fa34,$fa35,$fa36,$fa37,$fa38,$fa39,$fa3a,$fa3b,$fa3c,$fa3d,$fa3e,$fa3f,$fa40
 .dc.w $fa41,$fa42,$fa43,$fa44,$fa45,$fa46,$fa47,$fa48,$fa49,$fa4a,$fa4b,$fa4c,$fa4d,$fa4e,$fa4f,$fa50
 .dc.w $fa51,$fa52,$fa53,$fa54,$fa55,$fa56,$fa57,$fa58,$fa59,$fa5a,$fa5b,$fa5c,$fa5d,$fa5e,$fa5f,$fa60
 .dc.w $fa61,$fa62,$fa63,$fa64,$fa65,$fa66,$fa67,$fa68,$fa69,$fa6a,$fa6b,$fa6c,$fa6d,$fa6e,$fa6f,$fa70
 .dc.w $fa71,$fa72,$fa73,$fa74,$fa75,$fa76,$fa77,$fa78,$fa79,$fa7a,$fa7b,$fa7c,$fa7d,$fa7e,$fa7f,$fa80
 .dc.w $fa81,$fa82,$fa83,$fa84,$fa85,$fa86,$fa87,$fa88,$fa89,$fa8a,$fa8b,$fa8c,$fa8d,$fa8e,$fa8f,$fa90
 .dc.w $fa91,$fa92,$fa93,$fa94,$fa95,$fa96,$fa97,$fa98,$fa99,$fa9a,$fa9b,$fa9c,$fa9d,$fa9e,$fa9f,$faa0
 .dc.w $faa1,$faa2,$faa3,$faa4,$faa5,$faa6,$faa7,$faa8,$faa9,$faaa,$faab,$faac,$faad,$faae,$faaf,$fab0
 .dc.w $fab1,$fab2,$fab3,$fab4,$fab5,$fab6,$fab7,$fab8,$fab9,$faba,$fabb,$fabc,$fabd,$fabe,$fabf,$fac0
 .dc.w $fac1,$fac2,$fac3,$fac4,$fac5,$fac6,$fac7,$fac8,$fac9,$faca,$facb,$facc,$facd,$face,$facf,$fad0
 .dc.w $fad1,$fad2,$fad3,$fad4,$fad5,$fad6,$fad7,$fad8,$fad9,$fada,$fadb,$fadc,$fadd,$fade,$fadf,$fae0
 .dc.w $fae1,$fae2,$fae3,$fae4,$fae5,$fae6,$fae7,$fae8,$fae9,$faea,$faeb,$faec,$faed,$faee,$faef,$faf0
 .dc.w $faf1,$faf2,$faf3,$faf4,$faf5,$faf6,$faf7,$faf8,$faf9,$fafa,$fafb,$fafc,$fafd,$fafe,$faff,$fb00
 .dc.w $fb01,$fb02,$fb03,$fb04,$fb05,$fb06,$fb07,$fb08,$fb09,$fb0a,$fb0b,$fb0c,$fb0d,$fb0e,$fb0f,$fb10
 .dc.w $fb11,$fb12,$fb13,$fb14,$fb15,$fb16,$fb17,$fb18,$fb19,$fb1a,$fb1b,$fb1c,$fb1d,$fb1e,$fb1f,$fb20
 .dc.w $fb21,$fb22,$fb23,$fb24,$fb25,$fb26,$fb27,$fb28,$fb29,$fb2a,$fb2b,$fb2c,$fb2d,$fb2e,$fb2f,$fb30
 .dc.w $fb31,$fb32,$fb33,$fb34,$fb35,$fb36,$fb37,$fb38,$fb39,$fb3a,$fb3b,$fb3c,$fb3d,$fb3e,$fb3f,$fb40
 .dc.w $fb41,$fb42,$fb43,$fb44,$fb45,$fb46,$fb47,$fb48,$fb49,$fb4a,$fb4b,$fb4c,$fb4d,$fb4e,$fb4f,$fb50
 .dc.w $fb51,$fb52,$fb53,$fb54,$fb55,$fb56,$fb57,$fb58,$fb59,$fb5a,$fb5b,$fb5c,$fb5d,$fb5e,$fb5f,$fb60
 .dc.w $fb61,$fb62,$fb63,$fb64,$fb65,$fb66,$fb67,$fb68,$fb69,$fb6a,$fb6b,$fb6c,$fb6d,$fb6e,$fb6f,$fb70
 .dc.w $fb71,$fb72,$fb73,$fb74,$fb75,$fb76,$fb77,$fb78,$fb79,$fb7a,$fb7b,$fb7c,$fb7d,$fb7e,$fb7f,$fb80
 .dc.w $fb81,$fb82,$fb83,$fb84,$fb85,$fb86,$fb87,$fb88,$fb89,$fb8a,$fb8b,$fb8c,$fb8d,$fb8e,$fb8f,$fb90
 .dc.w $fb91,$fb92,$fb93,$fb94,$fb95,$fb96,$fb97,$fb98,$fb99,$fb9a,$fb9b,$fb9c,$fb9d,$fb9e,$fb9f,$fba0
 .dc.w $fba1,$fba2,$fba3,$fba4,$fba5,$fba6,$fba7,$fba8,$fba9,$fbaa,$fbab,$fbac,$fbad,$fbae,$fbaf,$fbb0
 .dc.w $fbb1,$fbb2,$fbb3,$fbb4,$fbb5,$fbb6,$fbb7,$fbb8,$fbb9,$fbba,$fbbb,$fbbc,$fbbd,$fbbe,$fbbf,$fbc0
 .dc.w $fbc1,$fbc2,$fbc3,$fbc4,$fbc5,$fbc6,$fbc7,$fbc8,$fbc9,$fbca,$fbcb,$fbcc,$fbcd,$fbce,$fbcf,$fbd0
 .dc.w $fbd1,$fbd2,$fbd3,$fbd4,$fbd5,$fbd6,$fbd7,$fbd8,$fbd9,$fbda,$fbdb,$fbdc,$fbdd,$fbde,$fbdf,$fbe0
 .dc.w $fbe1,$fbe2,$fbe3,$fbe4,$fbe5,$fbe6,$fbe7,$fbe8,$fbe9,$fbea,$fbeb,$fbec,$fbed,$fbee,$fbef,$fbf0
 .dc.w $fbf1,$fbf2,$fbf3,$fbf4,$fbf5,$fbf6,$fbf7,$fbf8,$fbf9,$fbfa,$fbfb,$fbfc,$fbfd,$fbfe,$fbff,$fc00
 .dc.w $0400,$0401,$0402,$0403,$0404,$0405,$0406,$0407,$0408,$0409,$040a,$040b,$040c,$040d,$040e,$040f
 .dc.w $0410,$0411,$0412,$0413,$0414,$0415,$0416,$0417,$0418,$0419,$041a,$041b,$041c,$041d,$041e,$041f
 .dc.w $0420,$0421,$0422,$0423,$0424,$0425,$0426,$0427,$0428,$0429,$042a,$042b,$042c,$042d,$042e,$042f
 .dc.w $0430,$0431,$0432,$0433,$0434,$0435,$0436,$0437,$0438,$0439,$043a,$043b,$043c,$043d,$043e,$043f
 .dc.w $0440,$0441,$0442,$0443,$0444,$0445,$0446,$0447,$0448,$0449,$044a,$044b,$044c,$044d,$044e,$044f
 .dc.w $0450,$0451,$0452,$0453,$0454,$0455,$0456,$0457,$0458,$0459,$045a,$045b,$045c,$045d,$045e,$045f
 .dc.w $0460,$0461,$0462,$0463,$0464,$0465,$0466,$0467,$0468,$0469,$046a,$046b,$046c,$046d,$046e,$046f
 .dc.w $0470,$0471,$0472,$0473,$0474,$0475,$0476,$0477,$0478,$0479,$047a,$047b,$047c,$047d,$047e,$047f
 .dc.w $0480,$0481,$0482,$0483,$0484,$0485,$0486,$0487,$0488,$0489,$048a,$048b,$048c,$048d,$048e,$048f
 .dc.w $0490,$0491,$0492,$0493,$0494,$0495,$0496,$0497,$0498,$0499,$049a,$049b,$049c,$049d,$049e,$049f
 .dc.w $04a0,$04a1,$04a2,$04a3,$04a4,$04a5,$04a6,$04a7,$04a8,$04a9,$04aa,$04ab,$04ac,$04ad,$04ae,$04af
 .dc.w $04b0,$04b1,$04b2,$04b3,$04b4,$04b5,$04b6,$04b7,$04b8,$04b9,$04ba,$04bb,$04bc,$04bd,$04be,$04bf
 .dc.w $04c0,$04c1,$04c2,$04c3,$04c4,$04c5,$04c6,$04c7,$04c8,$04c9,$04ca,$04cb,$04cc,$04cd,$04ce,$04cf
 .dc.w $04d0,$04d1,$04d2,$04d3,$04d4,$04d5,$04d6,$04d7,$04d8,$04d9,$04da,$04db,$04dc,$04dd,$04de,$04df
 .dc.w $04e0,$04e1,$04e2,$04e3,$04e4,$04e5,$04e6,$04e7,$04e8,$04e9,$04ea,$04eb,$04ec,$04ed,$04ee,$04ef
 .dc.w $04f0,$04f1,$04f2,$04f3,$04f4,$04f5,$04f6,$04f7,$04f8,$04f9,$04fa,$04fb,$04fc,$04fd,$04fe,$04ff
 .dc.w $0500,$0501,$0502,$0503,$0504,$0505,$0506,$0507,$0508,$0509,$050a,$050b,$050c,$050d,$050e,$050f
 .dc.w $0510,$0511,$0512,$0513,$0514,$0515,$0516,$0517,$0518,$0519,$051a,$051b,$051c,$051d,$051e,$051f
 .dc.w $0520,$0521,$0522,$0523,$0524,$0525,$0526,$0527,$0528,$0529,$052a,$052b,$052c,$052d,$052e,$052f
 .dc.w $0530,$0531,$0532,$0533,$0534,$0535,$0536,$0537,$0538,$0539,$053a,$053b,$053c,$053d,$053e,$053f
 .dc.w $0540,$0541,$0542,$0543,$0544,$0545,$0546,$0547,$0548,$0549,$054a,$054b,$054c,$054d,$054e,$054f
 .dc.w $0550,$0551,$0552,$0553,$0554,$0555,$0556,$0557,$0558,$0559,$055a,$055b,$055c,$055d,$055e,$055f
 .dc.w $0560,$0561,$0562,$0563,$0564,$0565,$0566,$0567,$0568,$0569,$056a,$056b,$056c,$056d,$056e,$056f
 .dc.w $0570,$0571,$0572,$0573,$0574,$0575,$0576,$0577,$0578,$0579,$057a,$057b,$057c,$057d,$057e,$057f
 .dc.w $0580,$0581,$0582,$0583,$0584,$0585,$0586,$0587,$0588,$0589,$058a,$058b,$058c,$058d,$058e,$058f
 .dc.w $0590,$0591,$0592,$0593,$0594,$0595,$0596,$0597,$0598,$0599,$059a,$059b,$059c,$059d,$059e,$059f
 .dc.w $05a0,$05a1,$05a2,$05a3,$05a4,$05a5,$05a6,$05a7,$05a8,$05a9,$05aa,$05ab,$05ac,$05ad,$05ae,$05af
 .dc.w $05b0,$05b1,$05b2,$05b3,$05b4,$05b5,$05b6,$05b7,$05b8,$05b9,$05ba,$05bb,$05bc,$05bd,$05be,$05bf
 .dc.w $05c0,$05c1,$05c2,$05c3,$05c4,$05c5,$05c6,$05c7,$05c8,$05c9,$05ca,$05cb,$05cc,$05cd,$05ce,$05cf
 .dc.w $05d0,$05d1,$05d2,$05d3,$05d4,$05d5,$05d6,$05d7,$05d8,$05d9,$05da,$05db,$05dc,$05dd,$05de,$05df
 .dc.w $05e0,$05e1,$05e2,$05e3,$05e4,$05e5,$05e6,$05e7,$05e8,$05e9,$05ea,$05eb,$05ec,$05ed,$05ee,$05ef
 .dc.w $05f0,$05f1,$05f2,$05f3,$05f4,$05f5,$05f6,$05f7,$05f8,$05f9,$05fa,$05fb,$05fc,$05fd,$05fe,$05ff
 .dc.w $0600,$0601,$0602,$0603,$0604,$0605,$0606,$0607,$0608,$0609,$060a,$060b,$060c,$060d,$060e,$060f
 .dc.w $0610,$0611,$0612,$0613,$0614,$0615,$0616,$0617,$0618,$0619,$061a,$061b,$061c,$061d,$061e,$061f
 .dc.w $0620,$0621,$0622,$0623,$0624,$0625,$0626,$0627,$0628,$0629,$062a,$062b,$062c,$062d,$062e,$062f
 .dc.w $0630,$0631,$0632,$0633,$0634,$0635,$0636,$0637,$0638,$0639,$063a,$063b,$063c,$063d,$063e,$063f
 .dc.w $0640,$0641,$0642,$0643,$0644,$0645,$0646,$0647,$0648,$0649,$064a,$064b,$064c,$064d,$064e,$064f
 .dc.w $0650,$0651,$0652,$0653,$0654,$0655,$0656,$0657,$0658,$0659,$065a,$065b,$065c,$065d,$065e,$065f
 .dc.w $0660,$0661,$0662,$0663,$0664,$0665,$0666,$0667,$0668,$0669,$066a,$066b,$066c,$066d,$066e,$066f
 .dc.w $0670,$0671,$0672,$0673,$0674,$0675,$0676,$0677,$0678,$0679,$067a,$067b,$067c,$067d,$067e,$067f
 .dc.w $0680,$0681,$0682,$0683,$0684,$0685,$0686,$0687,$0688,$0689,$068a,$068b,$068c,$068d,$068e,$068f
 .dc.w $0690,$0691,$0692,$0693,$0694,$0695,$0696,$0697,$0698,$0699,$069a,$069b,$069c,$069d,$069e,$069f
 .dc.w $06a0,$06a1,$06a2,$06a3,$06a4,$06a5,$06a6,$06a7,$06a8,$06a9,$06aa,$06ab,$06ac,$06ad,$06ae,$06af
 .dc.w $06b0,$06b1,$06b2,$06b3,$06b4,$06b5,$06b6,$06b7,$06b8,$06b9,$06ba,$06bb,$06bc,$06bd,$06be,$06bf
 .dc.w $06c0,$06c1,$06c2,$06c3,$06c4,$06c5,$06c6,$06c7,$06c8,$06c9,$06ca,$06cb,$06cc,$06cd,$06ce,$06cf
 .dc.w $06d0,$06d1,$06d2,$06d3,$06d4,$06d5,$06d6,$06d7,$06d8,$06d9,$06da,$06db,$06dc,$06dd,$06de,$06df
 .dc.w $06e0,$06e1,$06e2,$06e3,$06e4,$06e5,$06e6,$06e7,$06e8,$06e9,$06ea,$06eb,$06ec,$06ed,$06ee,$06ef
 .dc.w $06f0,$06f1,$06f2,$06f3,$06f4,$06f5,$06f6,$06f7,$06f8,$06f9,$06fa,$06fb,$06fc,$06fd,$06fe,$06ff
 .dc.w $0700,$0701,$0702,$0703,$0704,$0705,$0706,$0707,$0708,$0709,$070a,$070b,$070c,$070d,$070e,$070f
 .dc.w $0710,$0711,$0712,$0713,$0714,$0715,$0716,$0717,$0718,$0719,$071a,$071b,$071c,$071d,$071e,$071f
 .dc.w $0720,$0721,$0722,$0723,$0724,$0725,$0726,$0727,$0728,$0729,$072a,$072b,$072c,$072d,$072e,$072f
 .dc.w $0730,$0731,$0732,$0733,$0734,$0735,$0736,$0737,$0738,$0739,$073a,$073b,$073c,$073d,$073e,$073f
 .dc.w $0740,$0741,$0742,$0743,$0744,$0745,$0746,$0747,$0748,$0749,$074a,$074b,$074c,$074d,$074e,$074f
 .dc.w $0750,$0751,$0752,$0753,$0754,$0755,$0756,$0757,$0758,$0759,$075a,$075b,$075c,$075d,$075e,$075f
 .dc.w $0760,$0761,$0762,$0763,$0764,$0765,$0766,$0767,$0768,$0769,$076a,$076b,$076c,$076d,$076e,$076f
 .dc.w $0770,$0771,$0772,$0773,$0774,$0775,$0776,$0777,$0778,$0779,$077a,$077b,$077c,$077d,$077e,$077f
 .dc.w $0780,$0781,$0782,$0783,$0784,$0785,$0786,$0787,$0788,$0789,$078a,$078b,$078c,$078d,$078e,$078f
 .dc.w $0790,$0791,$0792,$0793,$0794,$0795,$0796,$0797,$0798,$0799,$079a,$079b,$079c,$079d,$079e,$079f
 .dc.w $07a0,$07a1,$07a2,$07a3,$07a4,$07a5,$07a6,$07a7,$07a8,$07a9,$07aa,$07ab,$07ac,$07ad,$07ae,$07af
 .dc.w $07b0,$07b1,$07b2,$07b3,$07b4,$07b5,$07b6,$07b7,$07b8,$07b9,$07ba,$07bb,$07bc,$07bd,$07be,$07bf
 .dc.w $07c0,$07c1,$07c2,$07c3,$07c4,$07c5,$07c6,$07c7,$07c8,$07c9,$07ca,$07cb,$07cc,$07cd,$07ce,$07cf
 .dc.w $07d0,$07d1,$07d2,$07d3,$07d4,$07d5,$07d6,$07d7,$07d8,$07d9,$07da,$07db,$07dc,$07dd,$07de,$07df
 .dc.w $07e0,$07e1,$07e2,$07e3,$07e4,$07e5,$07e6,$07e7,$07e8,$07e9,$07ea,$07eb,$07ec,$07ed,$07ee,$07ef
 .dc.w $07f0,$07f1,$07f2,$07f3,$07f4,$07f5,$07f6,$07f7,$07f8,$07f9,$07fa,$07fb,$07fc,$07fd,$07fe,$07ff
 .ENDIF

;	 #] DataBits Table: 
;	 #[ DC Luma Table:			; 256 Bytes

	.LONG

DCLTable:
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$57
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$68
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$57
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$79
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$57
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$68
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$57
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$8a
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$57
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$68
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$57
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$79
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$57
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$68
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$57
 .dc.b $20,$33,$31,$35,$20,$34,$32,$46,$20,$33,$31,$35,$20,$34,$32,$9b

;	 #] DC Luma Table: 
;	 #[ AC Luma Tree:			; 2176 Bytes
;		#[ Level 1:

ACLTree:
 .dc.l Skip2Bits,$00000001			; xx00			2	0/1
 .dc.l Skip3Bits,$00000003			; x001			3	0/3
 .dc.l Skip2Bits,$00000002			; xx10			2	0/2
 .dc.l Skip4Bits,$00010001			; 0011			4	1/1
 .dc.l Skip2Bits,$00000001			; xx00			2	0/1
 .dc.l EndOfBlock,0				; 0101			4	0/0 (EOB)
 .dc.l Skip2Bits,$00000002			; xx10			2	0/2
 .dc.l NextLevel,Level_0111			; 0111
 .dc.l Skip2Bits,$00000001			; xx00			2	0/1
 .dc.l Skip3Bits,$00000003			; x001			3	0/3
 .dc.l Skip2Bits,$00000002			; xx10			2	0/2
 .dc.l NextLevel,Level_1011			; 1011
 .dc.l Skip2Bits,$00000001			; xx00			2	0/1
 .dc.l Skip4Bits,$00000004			; 1101			4	0/4
 .dc.l Skip2Bits,$00000002			; xx10			2	0/2
 .dc.l NextLevel,Level_1111			; 1111

;		#] Level 1: 
;		#[ Level 2:

Level_0111:
 .dc.l Skip1Bit,$00020001			; xxx0 0111		5	2/1
 .dc.l Skip2Bits,$00030001			; xx01 0111		6	3/1
 .dc.l Skip1Bit,$00020001			; xxx0 0111		5	2/1
 .dc.l Skip2Bits,$00040001			; xx11 0111		6	4/1
 .dc.l Skip1Bit,$00020001			; xxx0 0111		5	2/1
 .dc.l Skip2Bits,$00030001			; xx01 0111		6	3/1
 .dc.l Skip1Bit,$00020001			; xxx0 0111		5	2/1
 .dc.l Skip2Bits,$00040001			; xx11 0111		6	4/1
 .dc.l Skip1Bit,$00020001			; xxx0 0111		5	2/1
 .dc.l Skip2Bits,$00030001			; xx01 0111		6	3/1
 .dc.l Skip1Bit,$00020001			; xxx0 0111		5	2/1
 .dc.l Skip2Bits,$00040001			; xx11 0111		6	4/1
 .dc.l Skip1Bit,$00020001			; xxx0 0111		5	2/1
 .dc.l Skip2Bits,$00030001			; xx01 0111		6	3/1
 .dc.l Skip1Bit,$00020001			; xxx0 0111		5	2/1
 .dc.l Skip2Bits,$00040001			; xx11 0111		6	4/1

Level_1011:
 .dc.l Skip1Bit,$00000005			; xxx0 1011		5	0/5
 .dc.l Skip1Bit,$00010002			; xxx1 1011		5	1/2
 .dc.l Skip1Bit,$00000005			; xxx0 1011		5	0/5
 .dc.l Skip1Bit,$00010002			; xxx1 1011		5	1/2
 .dc.l Skip1Bit,$00000005			; xxx0 1011		5	0/5
 .dc.l Skip1Bit,$00010002			; xxx1 1011		5	1/2
 .dc.l Skip1Bit,$00000005			; xxx0 1011		5	0/5
 .dc.l Skip1Bit,$00010002			; xxx1 1011		5	1/2
 .dc.l Skip1Bit,$00000005			; xxx0 1011		5	0/5
 .dc.l Skip1Bit,$00010002			; xxx1 1011		5	1/2
 .dc.l Skip1Bit,$00000005			; xxx0 1011		5	0/5
 .dc.l Skip1Bit,$00010002			; xxx1 1011		5	1/2
 .dc.l Skip1Bit,$00000005			; xxx0 1011		5	0/5
 .dc.l Skip1Bit,$00010002			; xxx1 1011		5	1/2
 .dc.l Skip1Bit,$00000005			; xxx0 1011		5	0/5
 .dc.l Skip1Bit,$00010002			; xxx1 1011		5	1/2

Level_1111:
 .dc.l Skip3Bits,$00000006			; x000 1111		7	0/6
 .dc.l Skip4Bits,$00000007			; 0001 1111		8	0/7
 .dc.l Skip3Bits,$00050001			; x010 1111		7	5/1
 .dc.l NextLevel,Level_0011_1111 		; 0011
 .dc.l Skip3Bits,$00010003			; x100 1111		7	1/3
 .dc.l Skip4Bits,$00070001			; 0101 1111		8	7/1
 .dc.l Skip3Bits,$00060001			; x110 1111		7	6/1
 .dc.l NextLevel,Level_0111_1111 		; 0111
 .dc.l Skip3Bits,$00000006			; x000 1111		7	0/6
 .dc.l Skip4Bits,$00020002			; 1001 1111		8	2/2
 .dc.l Skip3Bits,$00050001			; x010 1111		7	5/1
 .dc.l NextLevel,Level_1011_1111 		; 1011
 .dc.l Skip3Bits,$00010003			; x100 1111		7	1/3
 .dc.l NextLevel,Level_1101_1111 		; 1101
 .dc.l Skip3Bits,$00060001			; x110 1111		7	6/1
 .dc.l NextLevel,Level_1111_1111 		; 1111

;		#] Level 2: 
;		#[ Level 3:

Level_0011_1111:
 .dc.l Skip1Bit,$00080001			; xxx0 0011 1111	9	8/1
 .dc.l Skip1Bit,$00090001			; xxx1 0011 1111	9	9/1
 .dc.l Skip1Bit,$00080001			; xxx0 0011 1111	9	8/1
 .dc.l Skip1Bit,$00090001			; xxx1 0011 1111	9	9/1
 .dc.l Skip1Bit,$00080001			; xxx0 0011 1111	9	8/1
 .dc.l Skip1Bit,$00090001			; xxx1 0011 1111	9	9/1
 .dc.l Skip1Bit,$00080001			; xxx0 0011 1111	9	8/1
 .dc.l Skip1Bit,$00090001			; xxx1 0011 1111	9	9/1
 .dc.l Skip1Bit,$00080001			; xxx0 0011 1111	9	8/1
 .dc.l Skip1Bit,$00090001			; xxx1 0011 1111	9	9/1
 .dc.l Skip1Bit,$00080001			; xxx0 0011 1111	9	8/1
 .dc.l Skip1Bit,$00090001			; xxx1 0011 1111	9	9/1
 .dc.l Skip1Bit,$00080001			; xxx0 0011 1111	9	8/1
 .dc.l Skip1Bit,$00090001			; xxx1 0011 1111	9	9/1
 .dc.l Skip1Bit,$00080001			; xxx0 0011 1111	9	8/1
 .dc.l Skip1Bit,$00090001			; xxx1 0011 1111	9	9/1

Level_0111_1111:
 .dc.l Skip2Bits,$00040002			; xx00 0111 1111	10	4/2
 .dc.l Skip2Bits,$000c0001			; xx01 0111 1111	10	c/1
 .dc.l Skip2Bits,$000b0001			; xx10 0111 1111	10	b/1
 .dc.l Skip3Bits,$00010005			; x011 0111 1111	11	1/5
 .dc.l Skip2Bits,$00040002			; xx00 0111 1111	10	4/2
 .dc.l Skip2Bits,$000c0001			; xx01 0111 1111	10	c/1
 .dc.l Skip2Bits,$000b0001			; xx10 0111 1111	10	b/1
 .dc.l Skip3Bits,$00050002			; x111 0111 1111	11	5/2
 .dc.l Skip2Bits,$00040002			; xx00 0111 1111	10	4/2
 .dc.l Skip2Bits,$000c0001			; xx01 0111 1111	10	c/1
 .dc.l Skip2Bits,$000b0001			; xx10 0111 1111	10	b/1
 .dc.l Skip3Bits,$00010005			; x011 0111 1111	11	1/5
 .dc.l Skip2Bits,$00040002			; xx00 0111 1111	10	4/2
 .dc.l Skip2Bits,$000c0001			; xx01 0111 1111	10	c/1
 .dc.l Skip2Bits,$000b0001			; xx10 0111 1111	10	b/1
 .dc.l Skip3Bits,$00050002			; x111 0111 1111	11	5/2

Level_1011_1111:
 .dc.l Skip1Bit,$000a0001			; xxx0 1011 1111	9	a/1
 .dc.l Skip2Bits,$00000008			; xx01 1011 1111	10	0/8
 .dc.l Skip1Bit,$000a0001			; xxx0 1011 1111	9	a/1
 .dc.l Skip2Bits,$00020003			; xx11 1011 1111	10	2/3
 .dc.l Skip1Bit,$000a0001			; xxx0 1011 1111	9	a/1
 .dc.l Skip2Bits,$00000008			; xx01 1011 1111	10	0/8
 .dc.l Skip1Bit,$000a0001			; xxx0 1011 1111	9	a/1
 .dc.l Skip2Bits,$00020003			; xx11 1011 1111	10	2/3
 .dc.l Skip1Bit,$000a0001			; xxx0 1011 1111	9	a/1
 .dc.l Skip2Bits,$00000008			; xx01 1011 1111	10	0/8
 .dc.l Skip1Bit,$000a0001			; xxx0 1011 1111	9	a/1
 .dc.l Skip2Bits,$00020003			; xx11 1011 1111	10	2/3
 .dc.l Skip1Bit,$000a0001			; xxx0 1011 1111	9	a/1
 .dc.l Skip2Bits,$00000008			; xx01 1011 1111	10	0/8
 .dc.l Skip1Bit,$000a0001			; xxx0 1011 1111	9	a/1
 .dc.l Skip2Bits,$00020003			; xx11 1011 1111	10	2/3

Level_1101_1111:
 .dc.l Skip1Bit,$00010004			; xxx0 1101 1111	9	1/4
 .dc.l Skip1Bit,$00030002			; xxx1 1101 1111	9	3/2
 .dc.l Skip1Bit,$00010004			; xxx0 1101 1111	9	1/4
 .dc.l Skip1Bit,$00030002			; xxx1 1101 1111	9	3/2
 .dc.l Skip1Bit,$00010004			; xxx0 1101 1111	9	1/4
 .dc.l Skip1Bit,$00030002			; xxx1 1101 1111	9	3/2
 .dc.l Skip1Bit,$00010004			; xxx0 1101 1111	9	1/4
 .dc.l Skip1Bit,$00030002			; xxx1 1101 1111	9	3/2
 .dc.l Skip1Bit,$00010004			; xxx0 1101 1111	9	1/4
 .dc.l Skip1Bit,$00030002			; xxx1 1101 1111	9	3/2
 .dc.l Skip1Bit,$00010004			; xxx0 1101 1111	9	1/4
 .dc.l Skip1Bit,$00030002			; xxx1 1101 1111	9	3/2
 .dc.l Skip1Bit,$00010004			; xxx0 1101 1111	9	1/4
 .dc.l Skip1Bit,$00030002			; xxx1 1101 1111	9	3/2
 .dc.l Skip1Bit,$00010004			; xxx0 1101 1111	9	1/4
 .dc.l Skip1Bit,$00030002			; xxx1 1101 1111	9	3/2

Level_1111_1111:
 .dc.l Skip3Bits,$000d0001			; x000 1111 1111	11	d/1
 .dc.l NextLevel,Level_0001_1111_1111		; 0001
 .dc.l Skip4Bits,$00020004			; 0010 1111 1111	12	2/4
 .dc.l NextLevel,Level_0011_1111_1111		; 0011
 .dc.l ZeroRunLength,$00000040			; x100 1111 1111	11	f/0 (ZRL)
 .dc.l NextLevel,Level_0101_1111_1111		; 0101
 .dc.l Skip4Bits,$00060002			; 0110 1111 1111	12	6/2
 .dc.l NextLevel,Level_0111_1111_1111		; 0111
 .dc.l Skip3Bits,$000d0001			; x000 1111 1111	11	d/1
 .dc.l NextLevel,Level_1001_1111_1111		; 1001
 .dc.l Skip4Bits,$00030003			; 1010 1111 1111	12	3/3
 .dc.l NextLevel,Level_1011_1111_1111		; 1011
 .dc.l ZeroRunLength,$00000040			; x100 1111 1111	11	f/0 (ZRL)
 .dc.l NextLevel,Level_1101_1111_1111		; 1101
 .dc.l Skip4Bits,$00070002			; 1110 1111 1111	12	7/2
 .dc.l NextLevel,Level_1111_1111_1111		; 1111

;		#] Level 3: 
;		#[ Level 4:

Level_0001_1111_1111:
 .dc.l Skip3Bits,$00080002			; x000 0001 1111 1111	15	8/2
 .dc.l Skip4Bits,$0001000a			; 0001 0001 1111 1111	16	1/a
 .dc.l Skip4Bits,$00010006			; 0010 0001 1111 1111	16	1/6
 .dc.l Skip4Bits,$00020008			; 0011 0001 1111 1111	16	2/8
 .dc.l Skip4Bits,$00000009			; 0100 0001 1111 1111	16	0/9
 .dc.l Skip4Bits,$00020006			; 0101 0001 1111 1111	16	2/6
 .dc.l Skip4Bits,$00010008			; 0110 0001 1111 1111	16	1/8
 .dc.l Skip4Bits,$0002000a			; 0111 0001 1111 1111	16	2/a
 .dc.l Skip3Bits,$00080002			; x000 0001 1111 1111	15	8/2
 .dc.l Skip4Bits,$00020005			; 1001 0001 1111 1111	16	2/5
 .dc.l Skip4Bits,$00010007			; 1010 0001 1111 1111	16	1/7
 .dc.l Skip4Bits,$00020009			; 1011 0001 1111 1111	16	2/9
 .dc.l Skip4Bits,$0000000a			; 1100 0001 1111 1111	16	0/a
 .dc.l Skip4Bits,$00020007			; 1101 0001 1111 1111	16	2/7
 .dc.l Skip4Bits,$00010009			; 1110 0001 1111 1111	16	1/9
 .dc.l Skip4Bits,$00030004			; 1111 0001 1111 1111	16	3/4

Level_0011_1111_1111:
 .dc.l Skip4Bits,$00090004			; 0000 0011 1111 1111	16	9/4
 .dc.l Skip4Bits,$000a0003			; 0001 0011 1111 1111	16	a/3
 .dc.l Skip4Bits,$00090008			; 0010 0011 1111 1111	16	9/8
 .dc.l Skip4Bits,$000a0007			; 0011 0011 1111 1111	16	a/7
 .dc.l Skip4Bits,$00090006			; 0100 0011 1111 1111	16	9/6
 .dc.l Skip4Bits,$000a0005			; 0101 0011 1111 1111	16	a/5
 .dc.l Skip4Bits,$0009000a			; 0110 0011 1111 1111	16	9/a
 .dc.l Skip4Bits,$000a0009			; 0111 0011 1111 1111	16	a/9
 .dc.l Skip4Bits,$00090005			; 1000 0011 1111 1111	16	9/5
 .dc.l Skip4Bits,$000a0004			; 1001 0011 1111 1111	16	a/4
 .dc.l Skip4Bits,$00090009			; 1010 0011 1111 1111	16	9/9
 .dc.l Skip4Bits,$000a0008			; 1011 0011 1111 1111	16	a/8
 .dc.l Skip4Bits,$00090007			; 1100 0011 1111 1111	16	9/7
 .dc.l Skip4Bits,$000a0006			; 1101 0011 1111 1111	16	a/6
 .dc.l Skip4Bits,$000a0002			; 1110 0011 1111 1111	16	a/2
 .dc.l Skip4Bits,$000a000a			; 1111 0011 1111 1111	16	a/a

Level_0101_1111_1111:
 .dc.l Skip4Bits,$00050005			; 0000 0101 1111 1111	16	5/5
 .dc.l Skip4Bits,$00060005			; 0001 0101 1111 1111	16	6/5
 .dc.l Skip4Bits,$00050009			; 0010 0101 1111 1111	16	5/9
 .dc.l Skip4Bits,$00060009			; 0011 0101 1111 1111	16	6/9
 .dc.l Skip4Bits,$00050007			; 0100 0101 1111 1111	16	5/7
 .dc.l Skip4Bits,$00060007			; 0101 0101 1111 1111	16	6/7
 .dc.l Skip4Bits,$00060003			; 0110 0101 1111 1111	16	6/3
 .dc.l Skip4Bits,$00070003			; 0111 0101 1111 1111	16	7/3
 .dc.l Skip4Bits,$00050006			; 1000 0101 1111 1111	16	5/6
 .dc.l Skip4Bits,$00060006			; 1001 0101 1111 1111	16	6/6
 .dc.l Skip4Bits,$0005000a			; 1010 0101 1111 1111	16	5/a
 .dc.l Skip4Bits,$0006000a			; 1011 0101 1111 1111	16	6/a
 .dc.l Skip4Bits,$00050008			; 1100 0101 1111 1111	16	5/8
 .dc.l Skip4Bits,$00060008			; 1101 0101 1111 1111	16	6/8
 .dc.l Skip4Bits,$00060004			; 1110 0101 1111 1111	16	6/4
 .dc.l Skip4Bits,$00070004			; 1111 0101 1111 1111	16	7/4

Level_0111_1111_1111:
 .dc.l Skip4Bits,$000c0009			; 0000 0111 1111 1111	16	c/9
 .dc.l Skip4Bits,$000d0008			; 0001 0111 1111 1111	16	d/8
 .dc.l Skip4Bits,$000d0004			; 0010 0111 1111 1111	16	d/4
 .dc.l Skip4Bits,$000e0002			; 0011 0111 1111 1111	16	e/2
 .dc.l Skip4Bits,$000d0002			; 0100 0111 1111 1111	16	d/2
 .dc.l Skip4Bits,$000d000a			; 0101 0111 1111 1111	16	d/a
 .dc.l Skip4Bits,$000d0006			; 0110 0111 1111 1111	16	d/6
 .dc.l Skip4Bits,$000e0004			; 0111 0111 1111 1111	16	e/4
 .dc.l Skip4Bits,$000c000a			; 1000 0111 1111 1111	16	c/a
 .dc.l Skip4Bits,$000d0009			; 1001 0111 1111 1111	16	d/9
 .dc.l Skip4Bits,$000d0005			; 1010 0111 1111 1111	16	d/5
 .dc.l Skip4Bits,$000e0003			; 1011 0111 1111 1111	16	e/3
 .dc.l Skip4Bits,$000d0003			; 1100 0111 1111 1111	16	d/3
 .dc.l Skip4Bits,$000e0001			; 1101 0111 1111 1111	16	e/1
 .dc.l Skip4Bits,$000d0007			; 1110 0111 1111 1111	16	d/7
 .dc.l Skip4Bits,$000e0005			; 1111 0111 1111 1111	16	e/5

Level_1001_1111_1111:
 .dc.l Skip4Bits,$00030005			; 0000 1001 1111 1111	16	3/5
 .dc.l Skip4Bits,$00040005			; 0001 1001 1111 1111	16	4/5
 .dc.l Skip4Bits,$00030009			; 0010 1001 1111 1111	16	3/9
 .dc.l Skip4Bits,$00040009			; 0011 1001 1111 1111	16	4/9
 .dc.l Skip4Bits,$00030007			; 0100 1001 1111 1111	16	3/7
 .dc.l Skip4Bits,$00040007			; 0101 1001 1111 1111	16	4/7
 .dc.l Skip4Bits,$00040003			; 0110 1001 1111 1111	16	4/3
 .dc.l Skip4Bits,$00050003			; 0111 1001 1111 1111	16	5/3
 .dc.l Skip4Bits,$00030006			; 1000 1001 1111 1111	16	3/6
 .dc.l Skip4Bits,$00040006			; 1001 1001 1111 1111	16	4/6
 .dc.l Skip4Bits,$0003000a			; 1010 1001 1111 1111	16	3/a
 .dc.l Skip4Bits,$0004000a			; 1011 1001 1111 1111	16	4/a
 .dc.l Skip4Bits,$00030008			; 1100 1001 1111 1111	16	3/8
 .dc.l Skip4Bits,$00040008			; 1101 1001 1111 1111	16	4/8
 .dc.l Skip4Bits,$00040004			; 1110 1001 1111 1111	16	4/4
 .dc.l Skip4Bits,$00050004			; 1111 1001 1111 1111	16	5/4

Level_1011_1111_1111:
 .dc.l Skip4Bits,$000b0002			; 0000 1011 1111 1111	16	b/2
 .dc.l Skip4Bits,$000b000a			; 0001 1011 1111 1111	16	b/a
 .dc.l Skip4Bits,$000b0006			; 0010 1011 1111 1111	16	b/6
 .dc.l Skip4Bits,$000c0005			; 0011 1011 1111 1111	16	c/5
 .dc.l Skip4Bits,$000b0004			; 0100 1011 1111 1111	16	b/4
 .dc.l Skip4Bits,$000c0003			; 0101 1011 1111 1111	16	c/3
 .dc.l Skip4Bits,$000b0008			; 0110 1011 1111 1111	16	b/8
 .dc.l Skip4Bits,$000c0007			; 0111 1011 1111 1111	16	c/7
 .dc.l Skip4Bits,$000b0003			; 1000 1011 1111 1111	16	b/3
 .dc.l Skip4Bits,$000c0002			; 1001 1011 1111 1111	16	c/2
 .dc.l Skip4Bits,$000b0007			; 1010 1011 1111 1111	16	b/7
 .dc.l Skip4Bits,$000c0006			; 1011 1011 1111 1111	16	c/6
 .dc.l Skip4Bits,$000b0005			; 1100 1011 1111 1111	16	b/5
 .dc.l Skip4Bits,$000c0004			; 1101 1011 1111 1111	16	c/4
 .dc.l Skip4Bits,$000b0009			; 1110 1011 1111 1111	16	b/9
 .dc.l Skip4Bits,$000c0008			; 1111 1011 1111 1111	16	c/8

Level_1101_1111_1111:
 .dc.l Skip4Bits,$00070005			; 0000 1101 1111 1111	16	7/5
 .dc.l Skip4Bits,$00080005			; 0001 1101 1111 1111	16	8/5
 .dc.l Skip4Bits,$00070009			; 0010 1101 1111 1111	16	7/9
 .dc.l Skip4Bits,$00080009			; 0011 1101 1111 1111	16	8/9
 .dc.l Skip4Bits,$00070007			; 0100 1101 1111 1111	16	7/7
 .dc.l Skip4Bits,$00080007			; 0101 1101 1111 1111	16	8/7
 .dc.l Skip4Bits,$00080003			; 0110 1101 1111 1111	16	8/3
 .dc.l Skip4Bits,$00090002			; 0111 1101 1111 1111	16	9/2
 .dc.l Skip4Bits,$00070006			; 1000 1101 1111 1111	16	7/6
 .dc.l Skip4Bits,$00080006			; 1001 1101 1111 1111	16	8/6
 .dc.l Skip4Bits,$0007000a			; 1010 1101 1111 1111	16	7/a
 .dc.l Skip4Bits,$0008000a			; 1011 1101 1111 1111	16	8/a
 .dc.l Skip4Bits,$00070008			; 1100 1101 1111 1111	16	7/8
 .dc.l Skip4Bits,$00080008			; 1101 1101 1111 1111	16	8/8
 .dc.l Skip4Bits,$00080004			; 1110 1101 1111 1111	16	8/4
 .dc.l Skip4Bits,$00090003			; 1111 1101 1111 1111	16	9/3

Level_1111_1111_1111:
 .dc.l Skip4Bits,$000e0006			; 0000 1111 1111 1111	16	e/6
 .dc.l Skip4Bits,$000f0004			; 0001 1111 1111 1111	16	f/4
 .dc.l Skip4Bits,$000e000a			; 0010 1111 1111 1111	16	e/a
 .dc.l Skip4Bits,$000f0008			; 0011 1111 1111 1111	16	f/8
 .dc.l Skip4Bits,$000e0008			; 0100 1111 1111 1111	16	e/8
 .dc.l Skip4Bits,$000f0006			; 0101 1111 1111 1111	16	f/6
 .dc.l Skip4Bits,$000f0002			; 0110 1111 1111 1111	16	f/2
 .dc.l Skip4Bits,$000f000a			; 0111 1111 1111 1111	16	f/a
 .dc.l Skip4Bits,$000e0007			; 1000 1111 1111 1111	16	e/7
 .dc.l Skip4Bits,$000f0005			; 1001 1111 1111 1111	16	f/5
 .dc.l Skip4Bits,$000f0001			; 1010 1111 1111 1111	16	f/1
 .dc.l Skip4Bits,$000f0009			; 1011 1111 1111 1111	16	f/9
 .dc.l Skip4Bits,$000e0009			; 1100 1111 1111 1111	16	e/9
 .dc.l Skip4Bits,$000f0007			; 1101 1111 1111 1111	16	f/7
 .dc.l Skip4Bits,$000f0003			; 1110 1111 1111 1111	16	f/3
 .dc.l HuffmanError,0				; 1111 1111 1111 1111	16	(Error)

;		#] Level 4: 
;	 #] AC Luma Tree: 
;	 #[ ZigZag & Quantization Matrix:	; 256 Bytes

ZZQTMatrix:
 .dc.l $00010000,$00030400,$00052000,$00114000
 .dc.l $00092400,$00010800,$00030c00,$00052800
 .dc.l $00214400,$00416000,$01018000,$00816400
 .dc.l $00114800,$00092c00,$00011000,$00031400
 .dc.l $00053000,$00214c00,$00416800,$02018400
 .dc.l $0401a000,$1001c000,$0801a400,$01018800
 .dc.l $00816c00,$00115000,$00093400,$00011800
 .dc.l $00031c00,$00053800,$00215400,$00417000
 .dc.l $02018c00,$0401a800,$2001c400,$4001e000
 .dc.l $8001e400,$1001c800,$0801ac00,$01019000
 .dc.l $00817400,$00115800,$00093c00,$00215c00
 .dc.l $00417800,$02019400,$0401b000,$2001cc00
 .dc.l $4001e800,$8001ec00,$1001d000,$0801b400
 .dc.l $01019800,$00817c00,$02019c00,$0401b800
 .dc.l $2001d400,$4001f000,$8001f400,$1001d800
 .dc.l $0801bc00,$2001dc00,$4001f800,$8001fc00

;	 #] ZigZag & Quantization Matrix: 
;	 #[ Bank 0 Table:			; 56 bytes

Bank0Table:
 .dc.l ACCoefLoop
 .dc.l Fetch32Bits
 .dc.l DCLTable
 .dc.l DataMaskTable
 .dc.l DataBitsBuffer
 .dc.l ACLTree
 .dc.l FastDCT
 .dc.l ConvertLoop
 .dc.l 359
 .dc.l -88
 .dc.l -183
 .dc.l 454
 .dc.l 255
 .dc.l 32

;	 #] Bank 0 Table: 
;	 #[ Bank 1 Table:			; 60 Bytes

Bank1Table:
 .dc.l DCTXLoop
 .dc.l DCTYLoop
 .dc.l EndDCTPass
 .dc.l DUEndLoop
 .dc.l DCTPointers
 .dc.l NormTable+24
 .dc.l 23170
 .dc.l 12540
 .dc.l 30274
 .dc.l 8035
 .dc.l 1598
 .dc.l 4551
 .dc.l 6811
 .dc.l 128
 .dc.l 4096

;	 #] Bank 1 Table: 
;  #] MC68000 Tables: 
;  #[ GPU Declarations:

		.LONG
GPUCode:
		.GPU

;
; Huffman & Color Space Conversion Stuff (Bank0)
;
;			r0: Temporary Register
_CurrentBits	.equr	r1,0
;			r2: Temporary Register
;			r3: Temporary Register
_Prefetch0	.equr	r4,0
_Prefetch1	.equr	r5,0
_BitsCounter	.equr	r6,0
_BitsMissing	.equr	r7,0
_StreamPtr	.equr	r8,0
_ZZQTMatrix	.equr	r9,0
_MCUBuffer	.equr	r10,0
_DCLTable	.equr	r11,0			; MC68000 Table Pointer (Unchanged)
_DataMaskTable	.equr	r12,0			; GPU Table pointer (Unchanged)
_DataBitsBuffer .equr	r13,0			; MC68000 Table Pointer (Unchanged)
;			r14: Temporary Register
;			r15: Temporary Register
_Fetch32Bits	.equr	r16,0			; Routine Pointer (Unchanged)
_ACCoefLoop	.equr	r17,0			; Routine Pointer (Unchanged)
_0x20		.equr	r18,0			; Huffman Constant (Unchanged)
_0xff		.equr	r19,0			; Huffman Constant (Unchanged)
_ACLTree	.equr	r20,0			; MC68000 Table Pointer (Unchanged)
_DCTMask	.equr	r21,0
_FastDCT	.equr	r22,0			; Routine Pointer (Unchanged)
_SP		.equr	r23,0
_OUTLineSize	.equr	r24,0			; Output Buffer Line Size (Unchanged)
;			r25: Temporary Register
_ConvertLoop	.equr	r26,0			; Routine Pointer (Unchanged)
_RedCoef1	.equr	r27,0			; Color Conversion Constant (Unchanged)
_GreenCoef1	.equr	r28,0			; Color Conversion Constant (Unchanged)
_GreenCoef2	.equr	r29,0			; Color Conversion Constant (Unchanged)
_BlueCoef1	.equr	r30,0			; Color Conversion Constant (Unchanged)

;
; Inverse DCT Stuff (Bank1)
;
;			r0: Temporary Register
;			r1: Temporary Register
;			r2: Temporary Register
;			r3: Temporary Register
;			r4: Temporary Register
;			r5: Temporary Register
;			r6: Temporary Register
;			r7: Temporary Register
;			r8: Temporary Register
;			r9: Temporary Register
_DCTLoopCounter .equr	r10,1
_NormConstant	.equr	r11,1
_MCUPointers	.equr	r12,1
_cos1_4 	.equr	r13,1			; Inv. DCT Constant (Unchanged)
_SrcPointer	.equr	r14,1
_DstPointer	.equr	r15,1
_sin1_8 	.equr	r16,1			; Inv. DCT Constant (Unchanged)
_cos1_8 	.equr	r17,1			; Inv. DCT Constant (Unchanged)
_cos1_16	.equr	r18,1			; Inv. DCT Constant (Unchanged)
_sin1_16	.equr	r19,1			; Inv. DCT Constant (Unchanged)
_cos5_16	.equr	r20,1			; Inv. DCT Constant (Unchanged)
_sin5_16	.equr	r21,1			; Inv. DCT Constant (Unchanged)
_0x1000 	.equr	r22,1			; Inv. DCT Constant (Unchanged)
_DCTSwitch	.equr	r23,1
_0x80		.equr	r24,1			; Inv. DCT Constant (Unchanged)
_DCTXLoop	.equr	r25,1			; Routine Pointer (Unchanged)
_DCTYLoop	.equr	r26,1			; Routine Pointer (Unchanged)
_EndDCTPass	.equr	r27,1			; Routine Pointer (Unchanged)
_DUEndLoop	.equr	r28,1			; Routine Pointer (Unchanged)
_NormTable	.equr	r29,1
_DCTPointers	.equr	r30,1			; Table Pointer (Unchanged)

;
; Common Stuff (Bank0 & Bank1)
;
_G_Flags	.equr	r31

		.ORG	G_RAM
		.NOJPAD 			; Real programmers don't use Padding:-)
		.REGBANK0			; Start GPU Code in Bank0

;  #] GPU Declarations: 
;  #[ GPU Start Up:

GPUStartUp:	movei	#G_FLAGS,_G_Flags
		moveta	_G_Flags,_G_Flags
		movei	#Bank0Table,r14
		load	(r14),_ACCoefLoop
		load	(r14+1),_Fetch32Bits
		load	(r14+2),_DCLTable
		load	(r14+3),_DataMaskTable
		load	(r14+4),_DataBitsBuffer
		load	(r14+5),_ACLTree
		load	(r14+6),_FastDCT
		load	(r14+7),_ConvertLoop
		load	(r14+8),_RedCoef1
		load	(r14+9),_GreenCoef1
		load	(r14+10),_GreenCoef2
		load	(r14+11),_BlueCoef1
		load	(r14+12),_0xff
		load	(r14+13),_0x20
		movei	#B_OUTLineSize,r0
		moveq	#0,_BitsCounter
		load	(r0),_OUTLineSize
		movei	#B_INPointer,r0
		moveq	#0,_BitsMissing
		load	(r0),_StreamPtr
		load	(_StreamPtr),_Prefetch1
		addqt	#4,_StreamPtr
		load	(_G_Flags),r0
		bset	#$e,r0
		store	r0,(_G_Flags)
		.REGBANK1
		nop
		nop
		movei	#Bank1Table,r14
		load	(r14),_DCTXLoop
		load	(r14+1),_DCTYLoop
		load	(r14+2),_EndDCTPass
		load	(r14+3),_DUEndLoop
		load	(r14+4),_DCTPointers
		load	(r14+5),_NormTable
		load	(r14+6),_cos1_4
		load	(r14+7),_sin1_8
		load	(r14+8),_cos1_8
		load	(r14+9),_cos1_16
		load	(r14+10),_sin1_16
		load	(r14+11),_cos5_16
		load	(r14+12),_sin5_16
		load	(r14+13),_0x80
		load	(r14+14),_0x1000
		load	(_G_Flags),r0
		bclr	#$e,r0
		store	r0,(_G_Flags)
		.REGBANK0
		nop
		nop

;  #] GPU Start Up: 
;  #[ Fill MCU Buffer:

FillMCUBuffer:	movei	#MCUBuffer,r2
		moveq	#$10,r10
		moveq	#0,r0
		shlq	#2,r10			; $40
.Loop:		store	r0,(r2)
		addqt	#4,r2
		store	r0,(r2)
		addqt	#4,r2
		store	r0,(r2)
		addqt	#4,r2
		store	r0,(r2)
		addqt	#4,r2
		store	r0,(r2)
		addqt	#4,r2
		subq	#1,r10
		store	r0,(r2)
		jr	NE,.Loop
		addqt	#4,r2

;  #] Fill MCU Buffer: 
;  #[ Decode DUs (Huffman, Inv. DCT):
;	 #[ DU Inits:

DecodeMCU:	movei	#MCUPointers,r15
		movefa	_NormTable,r2
		moveta	r15,_MCUPointers
		subqt	#24,r2
		moveta	r2,_NormTable

;	 #] DU Inits: 
;	 #[ Decode DU:

DULoop:		cmpq	#8,_BitsCounter
		move	_0xff,r14
		load	(r15+1),_ZZQTMatrix
		jr	PL,DCHeader
		moveq	#0,_DCTMask
		move	PC,_SP
		jump	(_Fetch32Bits)
		sub	_BitsCounter,_BitsMissing
DCHeader:	and	_CurrentBits,r14	; Get 8 Bits
		load	(r15+2),_MCUBuffer
		add	_DCLTable,r14
		loadb	(r14),r0		; Get Header Size | Datas Size
		moveq	#$f,r14
		and	r0,r14			; Get Datas Size
		shrq	#4,r0			; Get Header Size
		sub	r0,_BitsCounter 	; Substract Header Size
		cmp	r14,_BitsCounter
		moveq	#2,r3
		jr	PL,DCDatas		; Test Datas Size &
		sh	r0,_CurrentBits 	; Remove Header Bits
		move	PC,_SP
		jump	(_Fetch32Bits)
		sub	_BitsCounter,_BitsMissing
DCDatas:	move	_CurrentBits,r0
		sh	r14,_CurrentBits	; Remove Datas Bits
		neg	r14
		load	(_ZZQTMatrix),r2	; Get Quantization Value
		sh	r14,r3			; Build Datas Offset
		add	r14,_BitsCounter	; Substract Datas Size
		shlq	#2,r14
		shlq	#1,r0
		load	(r14+_DataMaskTable),r14
		shrq	#16,r2
		and	r0,r14			; Mask Datas Bits
		load	(r15),r15		; Get Last DC Pointer
		add	r3,r14			; Add Datas Offset
		add	_DataBitsBuffer,r14
		loadw	(r14),r0		; Get Datas Value
		addqt	#4,_ZZQTMatrix		; Increment ZigZag & Quantization Table Pointer
		load	(r15),r3
		imult	r2,r0			; DC*QT[0]
		add	r0,r3			; Add to Last DC Coef.
		store	r3,(_MCUBuffer) 	; Store DC Coef.
		store	r3,(r15)		; And Last DC Value
ACCoefLoop:	cmpq	#4,_BitsCounter 	; Test if Enough Bits Available
		move	_ACLTree,r2		; Get Luma AC Tree Pointer
ACNibbleLoop:	jr	PL,ScanACTree
		moveq	#$f,r14
		move	PC,_SP
		jump	(_Fetch32Bits)
		sub	_BitsCounter,_BitsMissing
ScanACTree:	and	_CurrentBits,r14	; Get 4 Bits
		shlq	#3,r14			; * 8
		load	(r14+r2),r0		; Get AC Manager Address
		addqt	#4,r14
		jump	(r0)			; Jump to Next AC Manager &
		load	(r14+r2),r2		; Get Run/Size Values / New Tree Address
NextLevel:	shrq	#4,_CurrentBits
		cmpq	#8,_BitsCounter
		jr	ACNibbleLoop
		subqt	#4,_BitsCounter
ZeroRunLength:	shrq	#3,_CurrentBits
		subqt	#3,_BitsCounter
		jump	(_ACCoefLoop)
		add	r2,_ZZQTMatrix
Skip4Bits:	subqt	#4,_BitsCounter
		jr	HandleACCoef
		shrq	#4,_CurrentBits
Skip3Bits:	subqt	#3,_BitsCounter
		jr	HandleACCoef
		shrq	#3,_CurrentBits
Skip2Bits:	subqt	#2,_BitsCounter
		jr	HandleACCoef
		shrq	#2,_CurrentBits
Skip1Bit:	subqt	#1,_BitsCounter
		shrq	#1,_CurrentBits
HandleACCoef:	move	_0xff,r14
		and	r2,r14
		shrq	#14,r2
		cmp	r14,_BitsCounter
		moveq	#2,r3
		jr	PL,ACDatas
		add	r2,_ZZQTMatrix
		move	PC,_SP
		jump	(_Fetch32Bits)
		sub	_BitsCounter,_BitsMissing
ACDatas:	move	_CurrentBits,r0
		sub	r14,_BitsCounter
		sh	r14,_CurrentBits
		neg	r14
		shlq	#1,r0
		sh	r14,r3
		shlq	#2,r14
		load	(r14+_DataMaskTable),r14
		move	_0xff,r2
		and	r0,r14			; Mask Datas Bits
		load	(_ZZQTMatrix),r15	; Get Quantization Value
		add	r3,r14			; Add Datas Offset
		or	r15,_DCTMask		; Add AC Coef. to DCT Mask
		add	_DataBitsBuffer,r14
		shrq	#16,r15
		loadw	(r14),r0		; Get Datas Value
		and	r15,r2
		addqt	#4,_ZZQTMatrix		; Increment ZigZag & Quantization Matrix
		imult	r2,r0
		shrq	#8,r15	 		; Get ZigZag position
		jump	(_ACCoefLoop) 		; Loop &
		store	r0,(r15+_MCUBuffer)	; Store AC Coef.

EndOfBlock:	load	(_G_Flags),r0
		shrq	#4,_CurrentBits
		bset	#$e,r0
		shlq	#16,_DCTMask
		subqt	#4,_BitsCounter
		jump	EQ,(_FastDCT)
		store	r0,(_G_Flags)
		.REGBANK1

;	 #] Decode DU: 
;	 #[ Inverse DCT DU:
;		#[ DCT StartUp:

InvDCTMCU:	nop
		nop
		movefa	_DCTMask,_DCTSwitch
		addqt	#8,_MCUPointers
		shrq	#14,_DCTSwitch
		moveq	#8,_NormConstant
		movei	#$ff7f,_DCTLoopCounter
		shlq	#12,_NormConstant
DCTYLoop:	load	(_MCUPointers),_SrcPointer
		addqt	#4,_MCUPointers
		load	(_MCUPointers),_DstPointer
DCTXLoop:	moveq	#$c,r1
		and	_DCTSwitch,r1
		add	_DCTPointers,r1
		load	(r1),r1
		jump	(r1)			; Switch To Best DCT Handler
		shrq	#2,_DCTSwitch

;		#] DCT StartUp: 
;		#[ Even Odd Pass:

EvenOddPass:	load	(_SrcPointer),r0
		load	(_SrcPointer+4),r4
		move	r0,r8
		add	r4,r0
		sub	r4,r8
		load	(_SrcPointer+2),r2
		imult	_cos1_4,r0
		imult	_cos1_4,r8
		load	(_SrcPointer+6),r6
		move	r2,r9
		imult	_sin1_8,r2
		imult	_cos1_8,r9
		load	(_SrcPointer+3),r3
		move	r6,r4
		imult	_sin1_8,r6
		imult	_cos1_8,r4
		add	r6,r9
		sub	r4,r2
		load	(_SrcPointer+5),r5
		move	r8,r4
		add	r2,r8
		sub	r2,r4
		load	(_SrcPointer+1),r1
		move	r0,r6
		sub	r9,r0
		add	r9,r6
		load	(_SrcPointer+7),r7
		move	r3,r2
		add	r5,r3
		sub	r5,r2
		imult	_cos1_4,r3
		imult	_cos1_4,r2
		add	_0x1000,r3
		add	_0x1000,r2
		sharq	#$d,r3
		sharq	#$d,r2
		shlq	#2,r1
		shlq	#2,r7
		move	r1,r5
		add	r3,r1
		sub	r3,r5
		move	r7,r3
		add	r2,r7
		sub	r2,r3
		imultn	_cos1_16,r1
		imacn	_sin1_16,r7
		resmac	r9
		imultn	_cos5_16,r5
		imacn	_sin5_16,r3
		resmac	r2
		imult	_sin1_16,r1
		imult	_cos1_16,r7
		imult	_sin5_16,r5
		imult	_cos5_16,r3
		sub	r7,r1
		sub	r3,r5
		move	r6,r3
		add	r9,r6
		sub	r9,r3
		move	r8,r7
		add	r5,r8
		sub	r5,r7
		move	r4,r5
		add	r2,r4
		sub	r2,r5
		move	r0,r2
		add	r1,r0
		sub	r1,r2
		add	_NormConstant,r6
		add	_NormConstant,r8
		sharq	#$10,r6
		sharq	#$10,r8
		store	r6,(_DstPointer)
		add	_NormConstant,r4
		add	_NormConstant,r0
		store	r8,(_DstPointer+8)
		sharq	#$10,r4
		sharq	#$10,r0
		store	r4,(_DstPointer+$10)
		add	_NormConstant,r2
		add	_NormConstant,r5
		store	r0,(_DstPointer+$18)
		sharq	#$10,r2
		add	_0x80,_DstPointer
		sharq	#$10,r5
		store	r2,(_DstPointer)
		add	_NormConstant,r7
		add	_NormConstant,r3
		store	r5,(_DstPointer+8)
		sharq	#$10,r7
		sharq	#$10,r3
		store	r7,(_DstPointer+$10)
		shrq	#1,_DCTLoopCounter
		store	r3,(_DstPointer+$18)
EndDCTPass:	addqt	#$20,_SrcPointer	; Increment Source Pointer
		addqt	#4,_DstPointer		; Increment Destination Pointer
		jump	CS,(_DCTXLoop)
		sub	_0x80,_DstPointer
		shrq	#1,_DCTLoopCounter
		load	(_NormTable),_NormConstant
		subc	_DCTSwitch,_DCTSwitch
		jump	CS,(_DCTYLoop)
		addqt	#4,_MCUPointers
		jump	(_DUEndLoop)
		load	(_G_Flags),r0

;		#] Even Odd Pass: 
;		#[ Even Pass:

EvenPass:	load	(_SrcPointer),r0
		load	(_SrcPointer+4),r4
		move	r0,r8
		add	r4,r0
		sub	r4,r8
		load	(_SrcPointer+2),r2
		imult	_cos1_4,r0
		imult	_cos1_4,r8
		load	(_SrcPointer+6),r6
		move	r2,r9
		imult	_sin1_8,r2
		imult	_cos1_8,r9
		move	r6,r4
		imult	_sin1_8,r6
		imult	_cos1_8,r4
		add	r6,r9
		sub	r4,r2
		move	r0,r6
		sub	r9,r0
		add	r9,r6
		move	r8,r4
		add	r2,r8
		sub	r2,r4
		add	_NormConstant,r6
		add	_NormConstant,r8
		sharq	#$10,r6
		sharq	#$10,r8
		store	r6,(_DstPointer)
		add	_NormConstant,r4
		store	r8,(_DstPointer+8)
		sharq	#$10,r4
		add	_NormConstant,r0
		store	r4,(_DstPointer+$10)
		sharq	#$10,r0
		store	r0,(_DstPointer+$18)
		add	_0x80,_DstPointer
		store	r0,(_DstPointer)
		store	r4,(_DstPointer+8)
		shrq	#1,_DCTLoopCounter
		store	r8,(_DstPointer+$10)
		jump	(_EndDCTPass)
		store	r6,(_DstPointer+$18)

;		#] Even Pass: 
;		#[ Odd Pass:

OddPass:	load	(_SrcPointer+3),r3
		load	(_SrcPointer+5),r5
		move	r3,r2
		add	r5,r3
		sub	r5,r2
		load	(_SrcPointer+1),r1
		imult	_cos1_4,r3
		imult	_cos1_4,r2
		add	_0x1000,r3
		load	(_SrcPointer+7),r7
		add	_0x1000,r2
		sharq	#$d,r3
		sharq	#$d,r2
		shlq	#2,r1
		shlq	#2,r7
		move	r1,r5
		add	r3,r1
		sub	r3,r5
		move	r7,r3
		add	r2,r7
		sub	r2,r3
		imultn	_cos1_16,r1
		imacn	_sin1_16,r7
		resmac	r9
		imultn	_cos5_16,r5
		imacn	_sin5_16,r3
		resmac	r2
		imult	_sin1_16,r1
		imult	_cos1_16,r7
		imult	_sin5_16,r5
		imult	_cos5_16,r3
		sub	r7,r1
		sub	r3,r5
		add	_NormConstant,r9
		add	_NormConstant,r5
		sharq	#$10,r9
		sharq	#$10,r5
		store	r9,(_DstPointer)
		add	_NormConstant,r2
		add	_NormConstant,r1
		store	r5,(_DstPointer+8)
		sharq	#$10,r2
		sharq	#$10,r1
		store	r2,(_DstPointer+$10)
		neg	r9
		store	r1,(_DstPointer+$18)
		add	_0x80,_DstPointer
		neg	r5
		store	r9,(_DstPointer+$18)
		neg	r2
		store	r5,(_DstPointer+$10)
		neg	r1
		shrq	#1,_DCTLoopCounter
		store	r2,(_DstPointer+8)
		jump	(_EndDCTPass)
		store	r1,(_DstPointer)

;		#] Odd Pass: 
;		#[ Fast Pass:

FastPass:	moveq	#0,r0
		store	r0,(_DstPointer)
		store	r0,(_DstPointer+8)
		store	r0,(_DstPointer+$10)
		store	r0,(_DstPointer+$18)
		add	_0x80,_DstPointer
		store	r0,(_DstPointer)
		store	r0,(_DstPointer+8)
		store	r0,(_DstPointer+$10)
		store	r0,(_DstPointer+$18)
		jump	(_EndDCTPass)
		shrq	#1,_DCTLoopCounter

;		#] Fast Pass: 
;		#[ Fast DCT:

FastDCT:	nop
		nop
		addqt	#8,_MCUPointers
		load	(_MCUPointers),r1
		moveq	#8,r3
		load	(r1),r0
		add	r1,r3
		addqt	#16,_MCUPointers
		load	(_NormTable),_NormConstant
		moveq	#4,r2
		shlq	#13,r0
		add	r1,r2
		add	_NormConstant,r0
		move	r1,r4
		sharq	#16,r0
		subqt	#4,r4
		moveq	#$f,r5
.Loop:		store	r0,(r1)
		addqt	#$10,r4
		store	r0,(r2)
		addqt	#$10,r1
		store	r0,(r3)
		addqt	#$10,r2
		store	r0,(r4)
		addqt	#$10,r3
		jr	NE,.Loop
		subq	#1,r5
		load	(_G_Flags),r0

;		#] Fast DCT: 
;	 #] Inverse DCT DU: 
;	 #[ DU End Loop:

DUEndLoop:	addqt	#4,_NormTable
		load	(_MCUPointers),r2
		bclr	#$e,r0
		addqt	#4,_MCUPointers
		moveta	r2,r2
		store	r0,(_G_Flags)
		.REGBANK0
		nop
		nop
		jump	(r2)
		movefa	_MCUPointers,r15

;	 #] DU End Loop: 
;  #] Decode DUs (Huffman, Inv. DCT): 
;  #[ Convert MCU:
;	 #[ Convert CRY15/CRY16 MCU:

		.IF	(CRY15|CRY16)
ConvertMCU:	movei	#CopyPointers,r2
		moveta	r4,r4
		movei	#B_OUTPointer,r0
		moveta	r5,r5
		load	(r0),r0
		moveta	r6,r6
		moveta	r7,r7
		moveta	r8,r8
		moveta	r11,r2
		moveta	r12,r3
		moveta	r13,r9
		moveta	r2,r0
		moveta	r0,r1
		movei	#RGBToCRY,r11
		movei	#CRYTable,r12
BlockLoop:	movefa	r0,r15
		load	(r15),r14		; Y Pointer
		load	(r15+1),r9		; Cb Pointer
		load	(r15+2),r25		; Cr Pointer
		movefa	r1,r0
		load	(r15+3),r15		; Output Offset
		movei	#$3def7,r5
		add	r0,r15
ConvertLoop:	load	(r9),r2
		load	(r25),r3
		imultn	_GreenCoef1,r2
		imacn	_GreenCoef2,r3
		resmac	r0
		imult	_BlueCoef1,r2
		imult	_RedCoef1,r3
		sharq	#8,r2			; - Cb * 0.31414 - Cr * 0.71414
		sharq	#8,r3			; + Cb * 1.77200
		load	(r14),r6
		move	PC,_SP
		jump	(r11)
		sharq	#8,r0			; + Cr * 1.40200
		load	(r14+1),r6
		move	r7,r8
		move	PC,_SP
		jump	(r11)
		shlq	#16,r8
		or	r7,r8
		load	(r14+8),r6
		store	r8,(r15)		; CCCCRRRR YYYYYYY? CCCCRRRR YYYYYYY?
		move	PC,_SP
		jump	(r11)
		addq	#4,r9
		load	(r14+9),r6
		move	r7,r8
		move	PC,_SP
		jump	(r11)
		shlq	#16,r8
		addqt	#8,r14
		or	r7,r8
		shrq	#1,r5
		store	r8,(r15+_OUTLineSize)	; CCCCRRRR YYYYYYY? CCCCRRRR YYYYYYY?
		addqt	#4,r25
		jump	CS,(_ConvertLoop)
		addq	#4,r15
		add	_OUTLineSize,r15
		shrq	#1,r5
		subqt	#$10,r15
		addqt	#$20,r14
		addqt	#$10,r9
		addqt	#$10,r25
		jump	CS,(_ConvertLoop)
		add	_OUTLineSize,r15
		movefa	r0,r14
		load	(r14+4),r0
		addqt	#$14,r14
		jump	(r0)
		moveta	r14,r0
		.ENDIF

;	 #] Convert CRY15/CRY16 MCU: 
;	 #[ Convert RGB15/RGB16 MCU:

		.IF	(RGB15|RGB16)
ConvertMCU:	movei	#CopyPointers,r2
		moveta	r4,r4
		movei	#B_OUTPointer,r0
		moveta	r5,r5
		load	(r0),r0
		.IF	RGB15
		moveta	r7,r7
		.ENDIF
		moveta	r6,r6
		.IF	RGB15
		moveq	#1,r7
		.ENDIF
		moveta	r2,r0
		.IF	RGB15
		shlq	#16,r7
		.ENDIF
		moveta	r0,r1
		.IF	RGB15
		addqt	#1,r7
		.ENDIF
BlockLoop:	movefa	r0,r15
		load	(r15),r14		; Y Pointer
		load	(r15+1),r23		; Cb Pointer
		load	(r15+2),r25		; Cr Pointer
		movefa	r1,r0
		load	(r15+3),r15		; Output Offset
		movei	#$3def7,r5
		add	r0,r15
ConvertLoop:	load	(r23),r2
		load	(r25),r3
		imultn	_GreenCoef1,r2
		imacn	_GreenCoef2,r3
		resmac	r0
		imult	_BlueCoef1,r2
		imult	_RedCoef1,r3
		sharq	#8,r0			; - Cb * 0.31414 - Cr * 0.71414
		sharq	#8,r2			; + Cb * 1.77200
		sharq	#8,r3			; + Cr * 1.40200
		load	(r14),r6
		addq	#4,r23
		move	r6,r10
		move	r6,r4
		add	r3,r6			; Y + Cr * 1.40200
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		add	r2,r4			; Y + Cb * 1.77200
		sat8	r10
		sat8	r6
		sat8	r4
		shrq	#2,r10
		shrq	#3,r6
		shrq	#3,r4
		shlq	#16,r10
		shlq	#27,r6
		shlq	#22,r4
		or	r10,r6
		load	(r14+1),r10
		or	r4,r6
		move	r10,r4
		.IF	RGB15
		or	r7,r6
		.ENDIF
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		move	r4,r9
		add	r2,r4			; Y + Cb * 1.77200
		add	r3,r9			; Y + Cr * 1.40200
		sat8	r10
		sat8	r9
		sat8	r4
		shrq	#2,r10
		shrq	#3,r9
		shrq	#3,r4
		shlq	#11,r9
		shlq	#6,r4
		or	r10,r9
		load	(r14+8),r10
		or	r4,r9
		move	r10,r4
		or	r6,r9
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		store	r9,(r15)		; RRRRRBBB BBGGGGG? RRRRRBBB BBGGGGG?
		move	r4,r6
		add	r2,r4			; Y + Cb * 1.77200
		add	r3,r6			; Y + Cr * 1.40200
		sat8	r10
		sat8	r6
		sat8	r4
		shrq	#2,r10
		shrq	#3,r6
		shrq	#3,r4
		shlq	#16,r10
		shlq	#27,r6
		shlq	#22,r4
		or	r10,r6
		load	(r14+9),r10
		or	r4,r6
		move	r10,r4
		.IF	RGB15
		or	r7,r6
		.ENDIF
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		move	r4,r9
		add	r2,r4			; Y + Cb * 1.77200
		add	r3,r9			; Y + Cr * 1.40200
		sat8	r10
		sat8	r9
		sat8	r4
		shrq	#2,r10
		shrq	#3,r9
		shrq	#3,r4
		shlq	#11,r9
		shlq	#6,r4
		or	r10,r9
		or	r4,r9
		or	r6,r9
		store	r9,(r15+_OUTLineSize)	; RRRRRBBB BBGGGGG? RRRRRBBB BBGGGGG?
		shrq	#1,r5
		addqt	#4,r15
		addqt	#8,r14
		jump	CS,(_ConvertLoop)
		addq	#4,r25
		add	_OUTLineSize,r15
		shrq	#1,r5
		subqt	#$10,r15
		addqt	#$20,r14
		addqt	#$10,r23
		addqt	#$10,r25
		jump	CS,(_ConvertLoop)
		add	_OUTLineSize,r15
		movefa	r0,r14
		load	(r14+4),r0
		addqt	#$14,r14
		jump	(r0)
		moveta	r14,r0
		.ENDIF

;	 #] Convert RGB15/RGB16 MCU: 
;	 #[ Convert RGB32 MCU:

		.IF	RGB32
ConvertMCU:	movei	#CopyPointers,r2
		moveta	r4,r4
		movei	#B_OUTPointer,r0
		moveta	r5,r5
		load	(r0),r0
		moveta	r2,r0
		moveta	r0,r1
BlockLoop:	movefa	r0,r15
		load	(r15),r14		; Y Pointer
		load	(r15+1),r23		; Cb Pointer
		load	(r15+2),r25		; Cr Pointer
		movefa	r1,r0
		load	(r15+3),r15		; Output Offset
		movei	#$3def7,r5
		add	r0,r15
ConvertLoop:	load	(r23),r2
		load	(r25),r3
		imultn	_GreenCoef1,r2
		imacn	_GreenCoef2,r3
		resmac	r0
		imult	_BlueCoef1,r2
		imult	_RedCoef1,r3
		sharq	#8,r0			; - Cb * 0.31414 - Cr * 0.71414
		sharq	#8,r2			; + Cb * 1.77200
		sharq	#8,r3			; + Cr * 1.40200
		load	(r14),r9
		addq	#4,r23
		move	r9,r10
		move	r9,r4
		add	r3,r9			; Y + Cr * 1.40200
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		add	r2,r4			; Y + Cb * 1.77200
		sat8	r9
		sat8	r10
		sat8	r4
		shlq	#16,r9
		shlq	#24,r10
		or	r10,r9
		load	(r14+8),r10
		or	r4,r9
		move	r10,r4
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		store	r9,(r15)		; GGGGGGGG RRRRRRRR 00000000 BBBBBBBB
		move	r4,r9
		add	r2,r4			; Y + Cb * 1.77200
		add	r3,r9			; Y + Cr * 1.40200
		sat8	r10
		sat8	r9
		sat8	r4
		shlq	#16,r9
		shlq	#24,r10
		or	r10,r9
		load	(r14+1),r10
		or	r4,r9
		move	r10,r4
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		store	r9,(r15+_OUTLineSize)	; GGGGGGGG RRRRRRRR 00000000 BBBBBBBB
		move	r4,r9
		add	r2,r4			; Y + Cb * 1.77200
		add	r3,r9			; Y + Cr * 1.40200
		sat8	r10
		sat8	r9
		sat8	r4
		addqt	#4,r15
		shlq	#16,r9
		shlq	#24,r10
		or	r10,r9
		load	(r14+9),r10
		or	r4,r9			; GGGGGGGG RRRRRRRR 00000000 BBBBBBBB
		move	r10,r4
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		store	r9,(r15)
		move	r4,r9
		add	r2,r4			; Y + Cb * 1.77200
		add	r3,r9			; Y + Cr * 1.40200
		sat8	r10
		sat8	r9
		sat8	r4
		shlq	#16,r9
		shlq	#24,r10
		or	r10,r9
		or	r4,r9
		store	r9,(r15+_OUTLineSize)	; GGGGGGGG RRRRRRRR 00000000 BBBBBBBB
		shrq	#1,r5
		addqt	#4,r15
		addqt	#8,r14
		jump	CS,(_ConvertLoop)
		addq	#4,r25
		add	_OUTLineSize,r15
		shrq	#1,r5
		subqt	#$20,r15
		addqt	#$20,r14
		addqt	#$10,r23
		addqt	#$10,r25
		jump	CS,(_ConvertLoop)
		add	_OUTLineSize,r15
		movefa	r0,r14
		load	(r14+4),r0
		addqt	#$14,r14
		jump	(r0)
		moveta	r14,r0
		.ENDIF

;	 #] Convert RGB32 MCU: 
;  #] Convert MCU: 
;  #[ MCU Loop:

MCULoop:	movefa	r1,r0
		movei	#B_Struct,r14
		addq	#$20,r0
		movefa	r4,r4
		.IF	RGB32
		addq	#$20,r0
		.ENDIF
		movefa	r5,r5
		store	r0,(r14+3)
		load	(r14+1),r25		; Current XCounter
		load	(r14),r3		; Loop Pointer
		subq	#1,r25
		.IF	(CRY15|CRY16|RGB15|RGB16)
		movefa	r6,r6
		.ENDIF
		.IF	(CRY15|CRY16|RGB15)
		movefa	r7,r7
		.ENDIF
		.IF	(CRY15|CRY16)
		movefa	r8,r8
		movefa	r2,r11
		movefa	r3,r12
		movefa	r9,r13
		.ENDIF
		jump	NE,(r3)
		store	r25,(r14+1)
		load	(r14+4),r25		; XCounter Backup
		move	_OUTLineSize,r15
		load	(r14+2),r2		; Current YCounter
		or	r25,r25			; GPU Score-Board Bug...
		store	r25,(r14+1)		; Restore XCounter
		.IF	(CRY15|CRY16|RGB15|RGB16)
		shlq	#5,r25
		.ENDIF
		.IF	RGB32
		shlq	#6,r25
		.ENDIF
		shlq	#4,r15
		sub	r25,r0
		add	r15,r0
		subq	#1,r2
		store	r0,(r14+3)
		jump	NE,(r3)
		store	r2,(r14+2)
		moveq	#FINISHED,r0

;  #] MCU Loop: 
;  #[ GPU End:

BPEGEnd:	movei	#BPEGStatus,r1
		store	r0,(r1)
		moveq	#0,r0
		movei	#G_CTRL,r1
.Wait:		jr	.Wait
		store	r0,(r1)			; Stop the GPU

;  #] GPU End: 
;  #[ Huffman Error:

HuffmanError:	jr	BPEGEnd
		moveq	#HUFFMANERROR,r0

;  #] Huffman Error: 
;  #[ Fetch 32 Bits:

Fetch32Bits:	addqt	#6,_SP
		jr	MI,.SameLong
		move	_0x20,_BitsCounter
		move	_Prefetch1,_Prefetch0
		load	(_StreamPtr),_Prefetch1
		addqt	#4,_StreamPtr
		jr	.NextLong
.SameLong:	move	_Prefetch0,_CurrentBits
		add	_BitsCounter,_BitsMissing
.NextLong:	move	_Prefetch1,r0
		sh	_BitsMissing,_CurrentBits
		sub	_BitsCounter,_BitsMissing
		sh	_BitsMissing,r0
		add	_BitsCounter,_BitsMissing
		jump	(_SP)
		or	r0,_CurrentBits

;  #] Fetch 32 Bits: 
;  #[ RGB To CRY:

		.IF (CRY15|CRY16)
RGBToCRY:	move	r6,r10
		move	r6,r4
		add	r3,r6			; Y + Cr * 1.40200
		add	r2,r4			; Y + Cb * 1.77200
		add	r0,r10			; Y - Cb * 0.31414 - Cr * 0.71414
		sat8	r6
		sat8	r10
		sat8	r4
		cmp	r10,r6
		move	r6,r7
		jr	PL,.1
		mult	_0xff,r6
		move	r10,r7
.1:		cmp	r4,r7
		addqt	#6,_SP
		jr	PL,.2
		mult	_0xff,r10
		move	r4,r7
.2:		mult	_0xff,r4
		cmpq	#0,r7
		move	_0xff,r13
		jr	NE,.3
		shlq	#8,r13
		jump	(_SP)
		nop
.3:		div	r7,r13
		mult	r13,r10
		mult	r13,r6
		mult	r13,r4
		shrq	#19,r10
		shrq	#19,r6
		shlq	#5,r10
		shlq	#10,r6
		shrq	#19,r4
		add	r10,r6
		add	r12,r4
		add	r6,r4
		.IF	CRY15
		bclr	#0,r7
		.ENDIF
		loadb	(r4),r6
		shlq	#8,r6
		jump	(_SP)
		or	r6,r7
		.ENDIF

;  #] RGB To CRY: 
;  #[ GPU Variables:				; 40 Bytes

		.LONG

B_Struct:	.dc.l	FillMCUBuffer		; MCU Loop Pointer
B_XCounter:	.dc.l	0			; Current X Counter
B_YCounter:	.dc.l	0			; Current Y Counter
B_OUTPointer:	.dc.l	0			; Current MCU Output Pointer
B_SaveXCounter:	.dc.l	0			; X Counter Backup
B_INPointer:	.dc.l	0			; BPEG Input Stream Pointer
B_OUTLineSize:	.dc.l	0			; BPEG Output Buffer Line Size (Bytes)

LastDCY:	.dc.l	0
LastDCCb:	.dc.l	0
LastDCCr:	.dc.l	0

;  #] GPU Variables: 
;  #[ GPU Tables:				; 336 Bytes
;	 #[ MCU Pointers:			; 168 Bytes

MCUPointers:	.dc.l	LastDCY,ZZQTLMatrix,MCUBuffer,MCUTmpBuffer,MCUTmpBuffer,MCUBuffer,DULoop
		.dc.l	LastDCY,ZZQTLMatrix,MCUBuffer+$100,MCUTmpBuffer,MCUTmpBuffer,MCUBuffer+$100,DULoop
		.dc.l	LastDCY,ZZQTLMatrix,MCUBuffer+$200,MCUTmpBuffer,MCUTmpBuffer,MCUBuffer+$200,DULoop
		.dc.l	LastDCY,ZZQTLMatrix,MCUBuffer+$300,MCUTmpBuffer,MCUTmpBuffer,MCUBuffer+$300,DULoop
		.dc.l	LastDCCb,ZZQTCMatrix,MCUBuffer+$400,MCUTmpBuffer,MCUTmpBuffer,MCUBuffer+$400,DULoop
		.dc.l	LastDCCr,ZZQTCMatrix,MCUBuffer+$500,MCUTmpBuffer,MCUTmpBuffer,MCUBuffer+$500,ConvertMCU

;	 #] MCU Pointers: 
;	 #[ DCT Pointers:			; 16 Bytes

DCTPointers:	.dc.l	FastPass
		.dc.l	EvenPass
		.dc.l	OddPass
		.dc.l	EvenOddPass

;	 #] DCT Pointers: 
;	 #[ Normalization Table:		; 24 Bytes

NormTable:	.dc.l	$808000			; Y (Output Range: $00 -> $ff)
		.dc.l	$808000			; Y (Output Range: $00 -> $ff)
		.dc.l	$808000			; Y (Output Range: $00 -> $ff)
		.dc.l	$808000			; Y (Output Range: $00 -> $ff)
		.dc.l	$008000			; Cb (Output Range: $80 -> $7f)
		.dc.l	$008000			; Cr (Output Range: $80 -> $7f)

;	 #] Normalization Table: 
;	 #[ Copy Pointers:			; 80 Bytes

		.IF	(CRY15|CRY16|RGB15|RGB16)
CopyPointers:	.dc.l	MCUBuffer,MCUBuffer+$400,MCUBuffer+$500,0,BlockLoop
		.dc.l	MCUBuffer+$100,MCUBuffer+$410,MCUBuffer+$510,$10,BlockLoop
		.dc.l	MCUBuffer+$200,MCUBuffer+$480,MCUBuffer+$580,0,BlockLoop
		.dc.l	MCUBuffer+$300,MCUBuffer+$490,MCUBuffer+$590,0,MCULoop
		.ENDIF

		.IF	RGB32
CopyPointers:	.dc.l	MCUBuffer,MCUBuffer+$400,MCUBuffer+$500,0,BlockLoop
		.dc.l	MCUBuffer+$100,MCUBuffer+$410,MCUBuffer+$510,$20,BlockLoop
		.dc.l	MCUBuffer+$200,MCUBuffer+$480,MCUBuffer+$580,0,BlockLoop
		.dc.l	MCUBuffer+$300,MCUBuffer+$490,MCUBuffer+$590,0,MCULoop
		.ENDIF

;	 #] Copy Pointers: 
;	 #[ Data Mask Table:			; 48 Bytes

		.dc.l	%111111111110,%011111111110,%001111111110
		.dc.l	%000111111110,%000011111110,%000001111110,%000000111110
		.dc.l	%000000011110,%000000001110,%000000000110,%000000000010
DataMaskTable:	.dc.l	%000000000000

;	 #] Data Mask Table: 
;  #] GPU Tables: 
;  #[ MCU Buffers:				; 2304 Bytes

ZZQTLMatrix	.equ	*			; Luminance Quantization Matrix ($100 Bytes)

ZZQTCMatrix	.equ	*+$100			; Chrominance Quantization Matrix ($100 Bytes)

MCUBuffer	.equ	*+$200			; I/O MCU Buffer ($600 Bytes)

MCUTmpBuffer	.equ	*+$800			; Inv. DCT Temporary Buffer ($100 Bytes)

;  #] MCU Buffers: 
;  #[ GPU EQURs Undefinition:

	.equrundef	_CurrentBits,_Prefetch0,_Prefetch1,_BitsCounter
	.equrundef	_BitsMissing,_StreamPtr,_ZZQTMatrix,_MCUBuffer
	.equrundef	_DCLTable,_DataMaskTable,_DataBitsBuffer
	.equrundef	_Fetch32Bits,_ACCoefLoop,_0x20,_0xff,_ACLTree
	.equrundef	_DCTMask,_FastDCT,_SP,_OUTLineSize,_ConvertLoop
	.equrundef	_RedCoef1,_GreenCoef1,_GreenCoef2,_BlueCoef1

	.equrundef	_DCTLoopCounter,_NormConstant,_MCUPointers
	.equrundef	_cos1_4,_SrcPointer,_DstPointer,_sin1_8,_cos1_8
	.equrundef	_cos1_16,_sin1_16,_cos5_16,_sin5_16,_0x1000
	.equrundef	_DCTSwitch,_0x80,_DCTXLoop,_DCTYLoop,_EndDCTPass
	.equrundef	_DUEndLoop,_NormTable,_DCTPointers

	.equrundef	_G_Flags

;  #] GPU EQURs Undefinition: 
;  #[ MC68000 Variables:

 .LONG
 .68000
GPUEndCode:

 .BSS

BPEGStatus:
 .ds.l 1

;  #] MC68000 Variables: 
;  #[ GPU RAM Check:


 .IF ((GPUEndCode-GPUCode)+2304)>4096
  .PRINT "G-RAM Overflow: ",/u/w ((GPUEndCode-GPUCode)+2304)-4096, " Bytes."
 .ELSE
  .PRINT "G-RAM Use: ",/u/w (GPUEndCode-GPUCode), " Bytes (Code & Tables)."
  .PRINT "           ",/u/w 2304, " Bytes (Buffers)."
  .PRINT "           ",/u/w 4096-((GPUEndCode-GPUCode)+2304), " Bytes (Free)."
 .ENDIF
 .END

;  #] GPU RAM Check: 

