;*======================================================================*
;*                TITLE:    STARTUP.S                                   *
;*                Function: Startup Routines and Main Loop	        *
;*			    NOTE: Link this file <<<< FIRST >>>>	*
;*                                                                      *
;*                Project #:              JAGUAR                        *
;*                                                                      *
;*                Programmer:             Cary J. Gee                   *
;*                                                                      *
;*              COPYRIGHT 1992,1993 Atari U.S. Corporation              *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                                                                      *
;*======================================================================*
	.title	"STARTUP.S - System Startup Routines"

BAR_ON EQU	0


;*======================================================================*
;*	INCLUDE FILES
;*======================================================================*

;*======================================================================*
;*	EXTERNAL SYMBOLS
;*======================================================================*


;*======================================================================*
;*	EXTERNAL ROUTINES
;*======================================================================*

	.extern	InitJag
	.extern	_Clear
	.extern	_main

;*======================================================================*
;*	PUBLIC SYMBOLS
;*======================================================================*

	.globl	_v_bas_ad
	.globl	NewScreen

;*======================================================================*
;*	PUBLIC ROUTINES
;*======================================================================*

	.globl	startup

;*======================================================================*
;*	LOCAL EQUATES
;*======================================================================*


;*======================================================================*
;*	SUBROUTINE AREA
;*======================================================================*

	.text

;*======================================================================*
;*	startup - Link this file ************** FIRST ***************
;*======================================================================*
startup:
	move.l	#newstack,a7

	jsr	InitJag
	jsr	_Clear				; use blitter to clear screen
	jsr	_main

_illegal::
	illegal


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; A call to this label is always automatically inserted into the main()
; function by GCC to init the runtime library.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
___main::
	rts

;*======================================================================*
;*	LOCAL RAM
;*======================================================================*
	.bss
	.phrase
_v_bas_ad:	ds.l	1
	.phrase


NewScreen:
		ds.w	160000			; memory for the screen

_endstack::
		ds.l	4000			; 8k for stack

_newstack::
newstack:
		ds.l	1



	.end


;*======================================================================*
;*				EOF
;*======================================================================*
