/*
 *		OSBIND.H		Mnemonic names for operating system calls
 * last change
 *  -jerry: 1994/09/21 
 */

#ifndef _OSBIND_H
#define _OSBIND_H


extern	long	gemdos();
extern	long	bios();
extern	long	xbios();
extern	short	bdos();

/*
 *		GEMDOS	(trap1)
 */
#define Pterm0()						gemdos(0x00)
#define Cconin()						gemdos(0x01)
#define Cconout(c)						gemdos(0x02,c)
#define Cauxin()						(int)gemdos(0x03)
#define Cauxout(c)						gemdos(0x04,c)
#define Cprnout(c)						(int)gemdos(0x05,c)
#define Crawio(data)					gemdos(0x06,data)
#define Crawcin()						gemdos(0x07)
#define Cnecin()						gemdos(0x08)
#define Cconws(s)						gemdos(0x09,s)
#define Cconrs(buf)						gemdos(0x0A,buf)
#define Cconis()						(int)gemdos(0x0B)
#define Dsetdrv(d)						gemdos(0x0E,d)
#define Cconos()						(int)gemdos(0x10)
#define Cprnos()						(int)gemdos(0x11)
#define Cauxis()						(int)gemdos(0x12)
#define Cauxos()						(int)gemdos(0x13)
#define Maddalt(start, size)			gemdos(20, start, size)
#define Dgetdrv()						(int)gemdos(0x19)
#define Fsetdta(dta)					gemdos(0x1A,dta)
#define Super(ptr)						gemdos(0x20,ptr)
#define Tgetdate()						(unsigned int)gemdos(0x2A)
#define Tsetdate(date)					(int)gemdos(0x2B,date)
#define Tgettime()						(unsigned int)gemdos(0x2C)
#define Tsettime(time)					(int)gemdos(0x2D,time)
#define Fgetdta()						(struct Dta *)gemdos(0x2F)
#define Sversion()						(int)gemdos(0x30)
#define Ptermres(save,rv)				gemdos(0x31,save,rv)
#define Dfree(buf,d)					gemdos(0x36,buf,d)
#define Dcreate(path)					(int)gemdos(0x39,path)
#define Ddelete(path)					(int)gemdos(0x3A,path)
#define Dsetpath(path)					(int)gemdos(0x3B,path)
#define Fcreate(fn,mode)				(int)gemdos(0x3C,fn,mode)
#define Fopen(fn,mode)					(int)gemdos(0x3D,fn,mode)
#define Fclose(h)						(int)gemdos(0x3E,h)
#define Fread(h,cnt,buf)				gemdos(0x3F,h,cnt,buf)
#define Fwrite(h,cnt,buf)				gemdos(0x40,h,cnt,buf)
#define Fdelete(fn)						(int)gemdos(0x41,fn)
#define Fseek(where,h,how)				gemdos(0x42,where,h,how)
#define Fattrib(fn,rwflag,attr)			(int)gemdos(0x43,fn,rwflag,attr)
#define Mxalloc(amount, mode)			(void *)gemdos(68, amount, mode)
#define Fdup(h)							(int)gemdos(0x45,h)
#define Fforce(hstd,hnew)				(int)gemdos(0x46,hstd,hnew)
#define Dgetpath(buf,d)					(int)gemdos(0x47,buf,d)
#define Malloc(size)					(void *)gemdos(0x48,size)
#define Mfree(ptr)						(int)gemdos(0x49,ptr)
#define Mshrink(ptr,size)				(int)gemdos(0x4A,0,ptr,size)
#define Pexec(mode,prog,tail,env)		gemdos(0x4B,mode,prog,tail,env)
#define Pterm(rv)						gemdos(0x4C,rv)
#define Fsfirst(filespec,attr)			(int)gemdos(0x4E,filespec,attr)
#define Fsnext()						(int)gemdos(0x4F)
#define Frename(zero,old,new)			(int)gemdos(0x56,zero,old,new)
#define Fdatime(timeptr,h,rwflag)		gemdos(0x57,timeptr,h,rwflag)
#define Flock(handle, mode,start,length)	gemdos(92, handle, mode,start,length)


/*
 *		BIOS	(trap13)
 */
#define Bconstat(dev)					bios(1,dev)
#define Bconin(dev)						bios(2,dev)
#define Bconout(dev,c)					bios(3,dev,c)
#define Rwabs(rwflag,buf,n,sector,d)	bios(4,rwflag,buf,n,sector,d)
#define Setexc(vnum,vptr)				bios(5,vnum,vptr)
#define Tickcal()						bios(6)
#define Getbpb(d)						(struct Bpb *)bios(7,d)
#define Bcostat(dev)					bios(8,dev)
#define Mediach(d)						bios(9,a)
#define Drvmap()						bios(10)
#define Getshift()						bios(11,-1)
#define Kbshift(data)					bios(11,data)

/*
 *		XBIOS	(trap14)
 */
#define Initmous(type,param,vptr)		xbios(0,type,param,vptr)
#define Physbase()						(void *)xbios(2)
#define Logbase()						(void *)xbios(3)
#define Getrez()						(int)xbios(4)
#define Setscreen(lscrn,pscrn,rez)		xbios(5,lscrn,pscrn,rez)
#define Setpalette(palptr)				xbios(6,palptr)
#define Setcolor(colornum,mixture)		xbios(7,colornum,mixture)
#define Floprd(buf,x,d,sect,trk,side,n) xbios(8,buf,x,d,sect,trk,side,n)
#define Flopwr(buf,x,d,sect,trk,side,n) xbios(9,buf,x,d,sect,trk,side,n)
#define Flopfmt(b,x,d,spt,trk,sd,i,m,v) xbios(10,b,x,d,spt,trk,sd,i,m,v)
#define Midiws(cnt,ptr)					xbios(12,cnt,ptr)
#define Mfpint(vnum,vptr)				xbios(13,vnum,vptr)
#define Iorec(iodev)					(struct Iorec *)xbios(14,iodev)
#define Rsconf(baud,flow,uc,rs,ts,sc)	(unsigned long)xbios(15,baud,flow,uc,rs,ts,sc)
#define Keytbl(nrml,shft,caps)			(struct Keytab *)xbios(16,nrml,shft,caps)
#define Random()						xbios(17)
#define Protobt(buf,serial,dsktyp,exec) xbios(18,buf,serial,dsktyp,exec)
#define Flopver(buf,x,d,sect,trk,sd,n)	xbios(19,buf,x,d,sect,trk,sd,n)
#define Scrdmp()						xbios(20)
#define Cursconf(func,rate)				xbios(21,func,rate)
#define Settime(time)					xbios(22,time)
#define Gettime()						xbios(23)
#define Bioskeys()						xbios(24)
#define Ikbdws(len_minus1,ptr)			xbios(25,len_minus1,ptr)
#define Jdisint(vnum)					xbios(26,vnum)
#define Jenabint(vnum)					xbios(27,vnum)
#define Giaccess(data,reg)				(char)xbios(28,data,reg)
#define Offgibit(ormask)				xbios(29,ormask)
#define Ongibit(andmask)				xbios(30,andmask)
#define Xbtimer(timer,ctrl,data,vnum)	xbios(31,timer,ctrl,data,vnum)
#define Dosound(ptr)					xbios(32,ptr)
#define Setprt(config)					xbios(33,config)
#define Kbdvbase()						(struct Kbdvecs *)xbios(34)
#define Kbrate(delay,reprate)			(int)xbios(35,delay,reprate)
#define Prtblk(pblkptr)					xbios(36,pblkptr)
#define Vsync()							xbios(37)
#define Supexec(funcptr)				xbios(38,funcptr)
#define Puntaes()						xbios(39)
#define Floprate(drive, seekrate)		xbios(41,drive, seekrate)
#define DMAread(sector, count, buffer, devno)	xbios(42,sector, count, buffer, devno)
#define DMAwrite(sector, count, buffer, devno)	xbios(43,sector, count, buffer, devno)
#define Bconmap(devno)					xbios(44,devno)
#define NMVaccess(op, start,count,buffer)	xbios(46,op, start,count,buffer)
#define Metainit(buffer)				xbios(48,buffer)
#define Blitmode(mode)					xbios(64,mode)
#define EsetShift(shftMode)				xbios(80, shftMode)
#define EgetShift()						xbios(81)
#define Esetbank(bankNum)				xbios(82, bankNum)
#define EsetColor(colorNum, color)		xbios(83,colorNum, color)
#define EsetPalette(colorNum, count, palettePtr)	xbios(84,colorNum, count, palettePtr)
#define EgetPalette(colorNum, count, palettePtr)	xbios(85,colorNum, count, palettePtr)
#define EsetGray(switch)				xbios(86, switch)
#define EsetSmear(switch)				xbios(87,switch)

#endif	_OSBIND_H
