/*
 * Definitions for MgMc-Cookie
 * Set TABs to 4
 */

#pragma once

#ifdef __MWERKS__	/* if compiled on a Macintosh */
#define cdecl
#pragma options align=mac68k
#else				/* if compiled on an Atari (Pure C) */
typedef char Boolean;
typedef char *Ptr, **Handle;
typedef unsigned char *StringPtr;
typedef void PixMap;
typedef Handle THPrint;
enum {false,true};
typedef void cdecl (*ProcPtr) (void);
#endif

typedef unsigned char byte;

typedef long cdecl (*GenProc) (short function, void *data);
typedef Boolean cdecl (*PrSetupProc) (Boolean alwaysInteractively);
typedef long cdecl (*MacCtProc) ();

typedef struct {
	THPrint		printHdl;
	PrSetupProc	doPrintSetup;
	long		reserved[8];
} PrintDesc;

enum {	/* status flags (bit numbers) for 'flags1' field */
	emul640x400Bit = 0,		/* 640*400 monochrome screen simulation */
	distinctShiftKeysBit,	/* right & left shift keys give diff. scan codes */
	realTwoButtonMouseBit,	/* 2-button mouse is connected */
	runningOn68KEmulatorBit	/* running on PowerPC with emulation */
};

typedef struct {	/* 'vers' resource definition, see Inside Mac docs */
	byte	vm;		/* first part of version number in BCD */
	byte	vn;		/* second and third part of version number in BCD */
	byte	vt;		/* development: 0x20, alpha: 0x40, beta: 0x60, release: 0x80 */
	byte	vd;		/* stage of prerelease version in BCD */
	short	region;	/* region code */
	char	str[];	/* version strings */
} MacVersion;

typedef struct {
	Boolean	inserted;		/* true: disk is inserted and available to GEMDOS/BIOS functions */
	Boolean	highDensity;	/* true: HD disk inserted, false: none or DD disk inserted */
	short	res1;			/* reserved */
	long	res2;			/* reserved */
} FlpDrvInfo;


/*
 * The XCMD interface
 * ------------------
 */

enum {
	XCMDMajorVersion	= 1,	/* BCD format */
	XCMDRevision		= 0x00	/* BCD format */
};

enum {	/* some XCMD specific error codes */
	unknownFunctionXErr	= -0x10003L,	/* on callXCMD: unknown function code */
	notInstalledXErr	= -0x10004L,	/* on openXCMD: no XCMD with this name found */
	notOpenedXErr		= -0x10005L,	/* on openXCMD: XCMD refused to open */
	alreadyClosedXErr	= -0x10006L,	/* on closeXCMD: calls to close > calls to open */
	generalXErr			= -1,
	noXErr				= 0
};

enum {	/* predefined XCMD function codes */
	/* negative cmds are functions called by MagiCMac in Mac environment */
	xcmdOpen	= -2,	/* called each time some MagiC program opens this XCMD */
	xcmdClose	= -1	/* called each time some MagiC program closes this XCMD */
};

typedef long XCMDHdl;

typedef XCMDHdl cdecl (*XCMDOpenProc) (char *xcmdName);	/* returns handle or error code */
typedef long cdecl (*XCMDCloseProc) (XCMDHdl xcmdHdl);	/* returns error code or 0 if no error */
typedef long cdecl (*XCMDGenProc) (XCMDHdl xcmdHdl, short function, void *data);
typedef GenProc cdecl (*XCMDGetAdrProc) (XCMDHdl xcmdHdl);	/* returns zero, if not valid */

typedef struct {	/* the information in this record is static and the record does not move */
	short			recSize;	/* size of this whole structure */
	byte			majorVers;	/* major version of the XCMD Mgr (== XCMDMajorVersion) */
	byte			revision;	/* revision version of the XCMD Mgr (== XCMDRevision) */
	/* The following routines may be called from Atari User mode or Atari Supervisor mode, */
	/* but not from Interrupts!                                                            */
	XCMDOpenProc	open;		/* negative values mean errors, all positive are valid handles */
	XCMDCloseProc	close;		/* negative values mean errors, zero means OK */
	XCMDGenProc		call;		/* call a user function */
	XCMDGetAdrProc	getAdr;		/* returns the address of the XCMD function dispatcher */
	long			res[16];	/* reserved, zero */
} XCMDMgrRec;


/*
 * The cookie structure
 * --------------------
 */

struct MgMcCookie {
	short		vers;			/* Version number of Cookie */
	short		size;
	long		flags1;			/* Bits: s. Flags1 */
	PixMap		*scrnPMPtr;
	Boolean		*updatePalette;
	ProcPtr		modeMac;
	ProcPtr		modeAtari;
	ProcPtr		getBaseMode;
	ProcPtr		getIntrCount;
	ProcPtr		intrLock;
	ProcPtr		intrUnlock;
	MacCtProc	callMacContext;
	Ptr			atariZeroPage;
	Ptr			macA5;
	ProcPtr		macAppSwitch;
	ProcPtr		controlSwitch;
	long		hardwareAttr1;
	long		hardwareAttr2;
	Ptr			magiC_BP;
	StringPtr	auxOutName;
	StringPtr	auxInName;
	ProcPtr		auxControl;
	PrintDesc	*printDescPtr;
	GenProc		configKernel;
	Boolean		*atariModePossible;	/* (1.04) */
	MacVersion	*versionOfMacAppl;	/* (1.06) vers. of MagiCMac application */
	void		*hwEmulSupport;		/* (1.08) supports optional system bus error handler */
	FlpDrvInfo	*floppyDrvInfoPtr;	/* (1.07) array (2 elements) of infos about floppy drives */
	XCMDMgrRec	*xcmdMgrPtr;		/* (1.08) */
	long		reserved[9];
};

typedef struct MgMcCookie MgMcCookie;

/* EOF */
