#ifndef _STIPSYNC_H_
#define _STIPSYNC_H_

#include "stip_def.h"

Boolean TCP_Create_Sync(ConnectionHandle *handle);
Boolean TCP_ActiveOpen_Sync(ConnectionHandle handle, ulong connectionTimeout, IPAddress remoteIPAddress, ushort remotePort, ushort *localPort);
Boolean TCP_PassiveOpen_Sync(ConnectionHandle handle, ulong connectionTimeout, ulong commandTimeout, IPAddress remoteIPAddress, ushort *remotePort, ushort *localPort);
Boolean TCP_GetBytesAvail_Sync(ConnectionHandle handle, ulong *bytesAvailable);
Boolean TCP_Receive_Sync(ConnectionHandle handle, ulong commandTimeout, void *buffer, ulong *bytesToReceive, ushort *urgent);
Boolean TCP_Send_Sync(ConnectionHandle handle, void *buffer, ulong bytesToSend, ushort urgent, ushort push);
Boolean TCP_GetStatus_Sync(ConnectionHandle handle, ushort *connectionState, ulong *unacknowledgedData, ulong *sendUnacknowledged, ulong *unreadData);
Boolean TCP_Close_Sync(ConnectionHandle handle);
Boolean TCP_Abort_Sync(ConnectionHandle handle);
Boolean TCP_Release_Sync(ConnectionHandle handle);
Boolean UDP_Create_Sync(ConnectionHandle *handle, ushort *localPort);
Boolean UDP_Read_Sync(ConnectionHandle handle, ulong commandTimeout, void *buffer, ulong *bytesRead);
Boolean UDP_Write_Sync(ConnectionHandle handle, IPAddress remoteIPAddress, ushort remotePort, void *buffer, ulong bytesToWrite);
Boolean UDP_Release_Sync(ConnectionHandle handle);
Boolean UDP_GetMTUSize_Sync(IPAddress remoteIPAddress, ulong *mtuSize);
Boolean DNR_Sync(IPAddress remoteIPAddress, ulong *addr);
Boolean GetMyIPAddr_Sync(ulong *addr, ulong *mask);
Boolean GetDNRIPAddr_Sync(ulong *addr);
Boolean Test_Sync(void);

#endif
